/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.controller;

import java.io.Serializable;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import tech.corefinance.common.annotation.PermissionAction;
import tech.corefinance.common.dto.GeneralApiResponse;
import tech.corefinance.common.dto.PageDto;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.service.CommonService;

public interface CrudController<I extends Serializable, T extends GenericModel<I>, D extends CreateUpdateDto<I>> {
    public CommonService<I, T, ?> getHandlingService();

    default public Converter<T, ?> getEntityConverter() {
        return null;
    }

    @PermissionAction(action="list")
    @PostMapping(value={"/"})
    default public PageDto<?> search(@RequestParam(value="pageSize", required=false, defaultValue="20") int pageSize, @RequestParam(value="pageIndex", required=false, defaultValue="0") int pageIndex, @RequestParam(value="orders", required=false, defaultValue="[]") List<Sort.Order> orders, @RequestParam(value="searchText", required=false, defaultValue="") String searchText) {
        Converter<T, ?> converter = this.getEntityConverter();
        Page<T> result = this.getHandlingService().searchData(searchText, pageSize, pageIndex, orders);
        if (converter == null) {
            return PageDto.createSuccessResponse(result);
        }
        return PageDto.createSuccessResponse(result.map(arg_0 -> converter.convert(arg_0)));
    }

    @PostMapping(value={"/create"})
    default public GeneralApiResponse<?> createEntity(@RequestBody D entity) {
        entity.setId(null);
        return this.createOrUpdate(entity);
    }

    default public GeneralApiResponse<?> createOrUpdate(@RequestBody D entity) {
        Converter<T, ?> converter = this.getEntityConverter();
        T result = this.getHandlingService().createOrUpdateEntity(entity);
        if (converter == null) {
            return new GeneralApiResponse<T>(result);
        }
        return new GeneralApiResponse<Object>(converter.convert(result));
    }

    @PutMapping(value={"/{entityId}"})
    default public GeneralApiResponse<?> updateEntity(@PathVariable(value="entityId") I entityId, @RequestBody D entity) {
        entity.setId(entityId);
        return this.createOrUpdate(entity);
    }

    @DeleteMapping(value={"/{entityId}"})
    default public GeneralApiResponse<Boolean> delete(@PathVariable(value="entityId") I entityId) {
        return new GeneralApiResponse<Boolean>(this.getHandlingService().deleteEntity(entityId));
    }

    @GetMapping(value={"/{entityId}"})
    default public GeneralApiResponse<Object> viewDetails(@PathVariable(value="entityId") I entityId) {
        Converter<T, ?> converter = this.getEntityConverter();
        T result = this.getHandlingService().getEntityDetails(entityId);
        if (converter == null) {
            return new GeneralApiResponse<Object>(result);
        }
        return new GeneralApiResponse<Object>(converter.convert(result));
    }
}

