/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantContext {
    private static final Logger log = LoggerFactory.getLogger(TenantContext.class);
    private static final TenantContext INSTANCE = new TenantContext();
    private ThreadLocal<String> tenantIdThreadLocal = new InheritableThreadLocal<String>();

    private TenantContext() {
        log.debug("Created TenantContext [{}]", (Object)this);
    }

    public static TenantContext getInstance() {
        return INSTANCE;
    }

    public void setTenantId(String tenantId) {
        this.tenantIdThreadLocal.set(tenantId);
    }

    public String getTenantId() {
        return this.tenantIdThreadLocal.get();
    }

    public void clearTenantId() {
        this.tenantIdThreadLocal.remove();
    }
}

