/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.PreRemove;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import tech.corefinance.common.audit.BasicUserAuditorAware;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.model.DeleteTracking;
import tech.corefinance.common.repository.DeleteTrackingRepository;
import tech.corefinance.common.util.CoreFinanceUtil;

@Configurable
@ConditionalOnProperty(name={"tech.corefinance.audit.enabled.delete-track"}, havingValue="true", matchIfMissing=true)
public class EntityDeleteListener {
    private static final Logger log = LoggerFactory.getLogger(EntityDeleteListener.class);

    @PreRemove
    private void beforeDelete(Object obj) {
        log.debug("Received delete action for {}!", obj);
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        DeleteTrackingRepository deleteTrackingRepository = (DeleteTrackingRepository)context.getBean(DeleteTrackingRepository.class);
        BasicUserAuditorAware auditorAware = (BasicUserAuditorAware)context.getBean(BasicUserAuditorAware.class);
        CoreFinanceUtil util = (CoreFinanceUtil)context.getBean(CoreFinanceUtil.class);
        ObjectMapper objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        log.debug("Creating delete tracking...");
        DeleteTracking deleteTracking = new DeleteTracking();
        auditorAware.getCurrentAuditor().ifPresent(a -> {
            deleteTracking.setCreatedBy((BasicUserDto)a);
            deleteTracking.setLastModifiedBy((BasicUserDto)a);
        });
        ZonedDateTime now = ZonedDateTime.now();
        deleteTracking.setLastModifiedDate(now);
        deleteTracking.setCreatedDate(now);
        deleteTracking.setEntityClassName(obj.getClass().getName());
        String json = util.writeValueToJson(objectMapper, obj);
        if ("Parsing json failure".equals(json)) {
            json = obj.toString();
        }
        deleteTracking.setEntityData(json);
        log.debug("Saving delete tracking info to database...");
        deleteTrackingRepository.save(deleteTracking);
        log.debug("Saved delete tracking info to database.");
    }
}

