package tech.corefinance.common.model;

import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.type.SqlTypes;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mongodb.core.mapping.Document;
import tech.corefinance.common.dto.BasicUserDto;

import java.time.ZonedDateTime;

@Data
@Document("delete_tracking")
@Table(name = "delete_tracking")
@Entity
public class DeleteTracking implements ModifiedDateTrackedEntity<ZonedDateTime>, AuditableEntity<BasicUserDto> {

    @Id
    @jakarta.persistence.Id
    @GeneratedValue(strategy = GenerationType.UUID)
    private String id;

    @Column(name = "entity_class_name")
    private String entityClassName;

    @Column(name = "entity_data")
    @JdbcTypeCode(SqlTypes.JSON)
    private String entityData;

    @CreatedDate
    @Column(name = "created_date")
    private ZonedDateTime createdDate;
    @CreatedBy
    @Column(name = "created_by")
    @JdbcTypeCode(SqlTypes.JSON)
    private BasicUserDto createdBy;
    @LastModifiedDate
    @Column(name = "last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedBy
    @Column(name = "last_modified_by")
    @JdbcTypeCode(SqlTypes.JSON)
    private BasicUserDto lastModifiedBy;
}
