/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.stereotype.Component;
import tech.corefinance.common.ex.ReflectiveIncorrectFieldException;
import tech.corefinance.common.service.ProxyUnbox;

@Component
public class TargetFieldProxyUnbox
implements ProxyUnbox {
    private static final String TARGET_FIELD_NAME = "target";

    @Override
    public Object unProxy(Object proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        try {
            Field targetField = handler.getClass().getDeclaredField(TARGET_FIELD_NAME);
            targetField.setAccessible(true);
            return targetField.get(handler);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectiveIncorrectFieldException(e);
        }
    }

    @Override
    public boolean canUnbox(Object proxy) {
        if (proxy != null && Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            try {
                return handler.getClass().getDeclaredField(TARGET_FIELD_NAME) != null;
            }
            catch (NoSuchFieldException e) {
                return false;
            }
        }
        return false;
    }
}

