/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.corefinance.common.model.Permission;
import tech.corefinance.common.repository.PermissionRepository;
import tech.corefinance.common.service.PermissionService;

@Service
@Transactional
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private PermissionRepository permissionRepository;

    @Override
    public PermissionRepository getRepository() {
        return this.permissionRepository;
    }

    @Override
    public List<Permission> loadByRoles(List<String> roleIds) {
        return this.permissionRepository.findByRoleIdIn(roleIds);
    }

    @Override
    public List<Permission> overrideByRoles(String roleId, List<Permission> permissions) {
        this.permissionRepository.deleteAllByRoleIdIn(List.of(roleId));
        ArrayList permissionsToSave = new ArrayList(permissions.size());
        LinkedList<Permission> permissionsIgnored = new LinkedList<Permission>();
        for (Permission p : permissions) {
            p.setRoleId(roleId);
            Optional<Permission> optional = this.permissionRepository.findFirstByRoleIdAndResourceTypeAndActionAndUrlAndRequestMethod(p.getRoleId(), p.getResourceType(), p.getAction(), p.getUrl(), p.getRequestMethod());
            optional.ifPresentOrElse(per -> permissionsIgnored.add((Permission)per), () -> permissionsToSave.add(p));
        }
        List saved = this.permissionRepository.saveAll(permissionsToSave);
        permissionsIgnored.addAll(saved);
        return permissionsIgnored;
    }

    public PermissionRepository getPermissionRepository() {
        return this.permissionRepository;
    }
}

