/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import tech.corefinance.common.config.JwtConfiguration;
import tech.corefinance.common.context.TenantContext;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.dto.JwtTokenDto;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.service.JwtService;
import tech.corefinance.common.service.JwtTokenParser;
import tech.corefinance.common.service.JwtVerifyAddOn;

@Service
@ConditionalOnProperty(prefix="tech.corefinance.security.jwt.enabled", name={"common"}, matchIfMissing=true, havingValue="true")
public class JwtServiceImpl
implements JwtService {
    private static final Logger log = LoggerFactory.getLogger(JwtServiceImpl.class);
    private static final String KEY_ALGORITHM = "RSA";
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private Algorithm algorithmRS;
    private JWTVerifier verifier;
    @Autowired
    private JwtConfiguration jwtConfiguration;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<JwtVerifyAddOn> jwtVerifyAddOns;
    @Autowired
    private JwtTokenParser jwtTokenParser;

    public JwtServiceImpl(@Value(value="${tech.corefinance.security.public-key}") String publicKey, @Value(value="${tech.corefinance.security.private-key:}") String privateKey, @Autowired ResourceLoader resourceLoader) throws GeneralSecurityException, IOException {
        log.debug("Creating JwtServiceImpl with key algorithm [{}]", (Object)KEY_ALGORITHM);
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM);
        log.debug("Loading public key [{}]", (Object)publicKey);
        Resource resource = resourceLoader.getResource(publicKey);
        byte[] decodedPublic = resource.getInputStream().readAllBytes();
        X509EncodedKeySpec spec = new X509EncodedKeySpec(decodedPublic);
        this.publicKey = (RSAPublicKey)kf.generatePublic(spec);
        if (!StringUtils.isBlank((CharSequence)privateKey)) {
            log.debug("Loading private key [{}]", (Object)privateKey);
            resource = resourceLoader.getResource(privateKey);
            byte[] decodedPrivate = resource.getInputStream().readAllBytes();
            PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(decodedPrivate);
            this.privateKey = (RSAPrivateKey)kf.generatePrivate(privateSpec);
        } else {
            log.debug("Skipped private key!");
        }
        this.algorithmRS = Algorithm.RSA256((RSAPublicKey)this.publicKey, (RSAPrivateKey)this.privateKey);
        log.debug("Creating JWT verifier...");
        this.verifier = JWT.require((Algorithm)this.algorithmRS).withIssuer("auth0").build();
        log.debug("Creating JwtServiceImpl done!");
    }

    @Override
    public JwtConfiguration getJwtConfiguration() {
        return this.jwtConfiguration;
    }

    @Override
    public String sign(Map<String, Serializable> data) {
        JWTCreator.Builder builder = JWT.create().withIssuer("auth0");
        for (Map.Entry<String, Serializable> entry : data.entrySet()) {
            this.addClaim(builder, entry.getKey(), entry.getValue());
        }
        builder.withIssuedAt(new Date());
        builder.withExpiresAt(new Date(System.currentTimeMillis() + this.jwtConfiguration.getExpiration() * 1000L));
        return builder.sign(this.algorithmRS);
    }

    private void addClaim(JWTCreator.Builder builder, String key, Serializable value) {
        if (value == null) {
            builder.withClaim(key, (String)null);
            return;
        }
        Class<?> valueClzz = value.getClass();
        if (String.class.isAssignableFrom(valueClzz) || UUID.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, value.toString());
        } else if (Integer.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, (Integer)value);
        } else if (Boolean.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, (Boolean)value);
        } else if (Double.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, (Double)value);
        } else if (Long.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, (Long)value);
        } else if (Date.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, (Date)value);
        } else if (String[].class.isAssignableFrom(valueClzz)) {
            builder.withArrayClaim(key, (String[])value);
        } else if (Integer[].class.isAssignableFrom(valueClzz)) {
            builder.withArrayClaim(key, (Integer[])value);
        } else if (int[].class.isAssignableFrom(valueClzz)) {
            int[] val = (int[])value;
            Integer[] arr = new Integer[val.length];
            for (int i = 0; i < val.length; ++i) {
                arr[i] = val[i];
            }
            builder.withArrayClaim(key, arr);
        } else if (Long[].class.isAssignableFrom(valueClzz)) {
            builder.withArrayClaim(key, (Long[])value);
        } else if (long[].class.isAssignableFrom(valueClzz)) {
            long[] val = (long[])value;
            Long[] arr = new Long[val.length];
            for (int i = 0; i < val.length; ++i) {
                arr[i] = val[i];
            }
            builder.withArrayClaim(key, arr);
        } else if (List.class.isAssignableFrom(valueClzz)) {
            log.debug("List value to sign {}", (Object)value);
            builder.withClaim(key, (List)((Object)value));
        } else if (Collection.class.isAssignableFrom(valueClzz)) {
            log.debug("Collection value to sign {}", (Object)value);
            builder.withClaim(key, new ArrayList((Collection)((Object)value)));
        } else if (Map.class.isAssignableFrom(valueClzz)) {
            log.debug("Map value to sign {}", (Object)value);
            builder.withClaim(key, (Map)((Object)value));
        } else if (Enum.class.isAssignableFrom(valueClzz)) {
            builder.withClaim(key, ((Enum)((Object)value)).name());
        }
    }

    @Override
    public DecodedJWT verify(String token, String deviceId, String ipaddress) {
        log.debug("Verifying token [{}] with device [{}] and IP [{}]", new Object[]{token, deviceId, ipaddress});
        DecodedJWT decodedJWT = this.verifier.verify(token);
        log.debug("Decoded JWT [{}]", (Object)decodedJWT);
        if (!deviceId.equalsIgnoreCase(decodedJWT.getClaim("deviceId").asString())) {
            throw new JWTVerificationException("Device ID miss matched in token and request!!");
        }
        if (!ipaddress.equalsIgnoreCase(decodedJWT.getClaim("loginIpAddr").asString())) {
            throw new JWTVerificationException("IP Address miss matched in token and request!!");
        }
        String requestTenant = TenantContext.getInstance().getTenantId();
        String tokenTenant = decodedJWT.getClaim("tenantId").asString();
        if (StringUtils.isNotBlank((CharSequence)requestTenant) && StringUtils.isNotBlank((CharSequence)tokenTenant) && !tokenTenant.equalsIgnoreCase(requestTenant)) {
            throw new JWTVerificationException("Cross tenant requested!!");
        }
        return decodedJWT;
    }

    @Override
    public String extractIpAddress(HttpServletRequest httpServletRequest) throws UnknownHostException {
        String externalIpaddress = httpServletRequest.getHeader("x-external-ip");
        if (StringUtils.isBlank((CharSequence)externalIpaddress)) {
            return httpServletRequest.getRemoteAddr();
        }
        return externalIpaddress;
    }

    @Override
    public Map<String, JwtTokenDto> retrieveTokenFromRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        log.debug("Retrieving data from request");
        String deviceId = httpServletRequest.getHeader("x-device-id");
        String ipAddress = this.extractIpAddress(httpServletRequest);
        log.debug("Device ID [{}] with ip address [{}]", (Object)deviceId, (Object)ipAddress);
        String authorizationHeader = httpServletRequest.getHeader("Authorization");
        log.debug("authorization in header [{}]", (Object)authorizationHeader);
        HashMap<String, JwtTokenDto> map = new HashMap<String, JwtTokenDto>();
        if (authorizationHeader != null) {
            if (authorizationHeader.length() <= "Bearer ".length()) {
                log.error("Invalid bearer token found!!! [{}]", (Object)authorizationHeader);
            } else {
                String token = authorizationHeader.substring("Bearer ".length());
                DecodedJWT decodedJWT = this.verify(token, deviceId, ipAddress);
                String json = new String(Base64.getDecoder().decode(decodedJWT.getPayload().getBytes()), StandardCharsets.UTF_8);
                JwtTokenDto jwtTokenDto = this.jwtTokenParser.parse(json);
                jwtTokenDto.setOriginalToken(token);
                log.debug("Decoded token [{}]", (Object)jwtTokenDto);
                jwtTokenDto = this.additionalJwtVerifyStep(jwtTokenDto, token, deviceId, ipAddress);
                log.debug("Completed add on verify!");
                if (jwtTokenDto != null) {
                    map.put(authorizationHeader, jwtTokenDto);
                } else {
                    log.error("Token fail the validation!");
                }
            }
        }
        return map;
    }

    @Override
    public Map<String, Serializable> buildLoginDataMap(JwtTokenDto jwtTokenDto) throws JsonProcessingException {
        log.debug("Building login map data...");
        HashMap<String, Serializable> jwtData = new HashMap<String, Serializable>();
        Class<?> clzz = jwtTokenDto.getClass();
        log.debug("Object class {}", clzz);
        this.putFieldData(jwtTokenDto, clzz, jwtData);
        log.debug("Put addition data to login token");
        jwtData.putAll(jwtTokenDto.getAdditionalInfo());
        log.info("Login token before add custom attributes [{}]", jwtData);
        jwtData.put("expiredIn", Long.valueOf(System.currentTimeMillis() + this.jwtConfiguration.getExpiration() * 1000L));
        jwtData.put("appVersion", (Serializable)((Object)this.objectMapper.writeValueAsString((Object)jwtTokenDto.getAppVersion())));
        log.debug("Original role in school {}", jwtTokenDto.getUserRoles());
        LinkedList<String> userRoles = new LinkedList<String>(jwtTokenDto.getUserRoles().stream().map(r -> {
            try {
                return this.objectMapper.writeValueAsString(r);
            }
            catch (JsonProcessingException e) {
                throw new ServiceProcessingException("error_sign_login_token", (Throwable)e);
            }
        }).toList());
        jwtData.put("userRoles", userRoles);
        jwtData.remove("additionalInfo");
        log.info("Login token before sign {}", jwtData);
        return jwtData;
    }

    private void putFieldData(JwtTokenDto jwtTokenDto, Class<?> clzz, Map<String, Serializable> jwtData) {
        Field[] fields;
        for (Field field : fields = clzz.getDeclaredFields()) {
            String fieldName = field.getName();
            log.debug("Checking field [{}] is static [{}]", (Object)fieldName, (Object)Modifier.isStatic(field.getModifiers()));
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                log.debug("Getting field data....");
                Object fieldData = PropertyUtils.getNestedProperty((Object)jwtTokenDto, (String)fieldName);
                log.debug("Field data [{}]", fieldData);
                if (fieldData != null && Serializable.class.isAssignableFrom(fieldData.getClass())) {
                    log.debug("Put field data to sign map");
                    jwtData.put(fieldName, (Serializable)fieldData);
                    continue;
                }
                log.debug("Field data is not Serializable.");
            }
            catch (ReflectiveOperationException e) {
                throw new ServiceProcessingException("errors.server.invalid_jwt_field", (Throwable)e);
            }
        }
        if (JwtTokenDto.class.isAssignableFrom(clzz = clzz.getSuperclass())) {
            log.debug("Re-check parent fields [{}]", clzz);
            this.putFieldData(jwtTokenDto, clzz, jwtData);
        }
    }

    @Override
    public Map<String, Serializable> buildRefreshTokenDataMap(JwtTokenDto jwtTokenDto, String token) throws JsonProcessingException {
        HashMap<String, Serializable> refreshJwtData = new HashMap<String, Serializable>();
        refreshJwtData.put("loginId", (Serializable)((Object)jwtTokenDto.getLoginId()));
        refreshJwtData.put("userId", (Serializable)((Object)jwtTokenDto.getUserId()));
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ServiceProcessingException("Login handling error!!!");
        }
        refreshJwtData.put("deviceId", (Serializable)((Object)jwtTokenDto.getDeviceId()));
        refreshJwtData.put("loginIpAddr", (Serializable)((Object)jwtTokenDto.getLoginIpAddr()));
        refreshJwtData.put("appPlatform", (Serializable)((Object)jwtTokenDto.getAppPlatform().name()));
        refreshJwtData.put("appVersion", (Serializable)((Object)this.objectMapper.writeValueAsString((Object)jwtTokenDto.getAppVersion())));
        log.debug("Put addition data to refresh token");
        refreshJwtData.putAll(jwtTokenDto.getAdditionalInfo());
        return refreshJwtData;
    }

    protected JwtTokenDto additionalJwtVerifyStep(JwtTokenDto jwtTokenDto, String token, String deviceId, String ipaddress) {
        if (this.jwtVerifyAddOns != null) {
            log.debug("Configured JWT verify addon {}", this.jwtVerifyAddOns);
            for (JwtVerifyAddOn addOn : this.jwtVerifyAddOns) {
                jwtTokenDto = addOn.additionalJwtVerify(jwtTokenDto, token, deviceId, ipaddress);
                if (jwtTokenDto != null) continue;
                return null;
            }
        }
        return jwtTokenDto;
    }

    @Override
    public BasicUserDto retrieveUserAsAttribute(JwtTokenDto jwtTokenDto) {
        if (jwtTokenDto == null) {
            return null;
        }
        BasicUserDto user = new BasicUserDto();
        user.setUserId(jwtTokenDto.getUserId());
        user.setEmail(jwtTokenDto.getUserEmail());
        user.setDisplayName(jwtTokenDto.getUserDisplayName());
        user.setUsername(jwtTokenDto.getUsername());
        return user;
    }
}

