/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.web.bind.annotation.RequestMethod;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;

@Document(value="resource_action")
@Table(name="resource_action")
@Entity
public class ResourceAction
implements CreateUpdateDto<String>,
GenericModel<String> {
    public static final String COMMON_ACTION_ADD = "add";
    public static final String COMMON_ACTION_UPDATE = "update";
    public static final String COMMON_ACTION_DELETE = "delete";
    public static final String COMMON_ACTION_LIST = "list";
    public static final String COMMON_ACTION_VIEW = "view";
    public static final String COMMON_ACTION_INITIAL = "initial";
    @org.springframework.data.annotation.Id
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @Column(name="resource_type")
    private String resourceType;
    private String action = "add";
    private String url;
    @Column(name="request_method")
    @Enumerated(value=EnumType.STRING)
    private RequestMethod requestMethod;

    public ResourceAction(String resourceType, String action, String url, RequestMethod requestMethod) {
        this.resourceType = resourceType;
        this.action = action;
        this.url = url;
        this.id = action + "-" + resourceType + "-" + url.replace("/", "_");
        this.requestMethod = requestMethod;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getAction() {
        return this.action;
    }

    public String getUrl() {
        return this.url;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceAction)) {
            return false;
        }
        ResourceAction other = (ResourceAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        RequestMethod this$requestMethod = this.getRequestMethod();
        RequestMethod other$requestMethod = other.getRequestMethod();
        return !(this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        RequestMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceAction(id=" + this.getId() + ", resourceType=" + this.getResourceType() + ", action=" + this.getAction() + ", url=" + this.getUrl() + ", requestMethod=" + this.getRequestMethod() + ")";
    }

    public ResourceAction() {
    }
}

