/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mongodb.core.mapping.Document;
import tech.corefinance.common.model.GenericModel;

@Document(collection="internal_service_config")
@Table(name="internal_service_config")
@Entity
public class InternalServiceConfig
implements GenericModel<String> {
    @org.springframework.data.annotation.Id
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @NotNull
    @Column(name="service_name")
    private String serviceName;
    @NotNull
    @Column(name="api_key")
    private String apiKey;
    private boolean activated = true;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;

    @Override
    public String getId() {
        return this.id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalServiceConfig)) {
            return false;
        }
        InternalServiceConfig other = (InternalServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActivated() != other.isActivated()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        return !(this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivated() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        return result;
    }

    public String toString() {
        return "InternalServiceConfig(id=" + this.getId() + ", serviceName=" + this.getServiceName() + ", apiKey=" + this.getApiKey() + ", activated=" + this.isActivated() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", createdDate=" + this.getCreatedDate() + ")";
    }
}

