/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.util.StringUtils;
import tech.corefinance.common.enums.CommonConstants;

public class AppVersion {
    private short major;
    private short minor;
    private short maintenance;
    private String build;

    public AppVersion() {
        this(CommonConstants.DEFAULT_VERSION_STRING);
    }

    public AppVersion(String jsonString) {
        if (jsonString.contains(".")) {
            String versionText = jsonString;
            int buildIndex = versionText.indexOf("-");
            if (buildIndex > 0) {
                this.build = versionText.substring(buildIndex);
                versionText = versionText.substring(0, buildIndex);
            }
            String[] arr = versionText.split("\\.");
            this.major = Short.parseShort(arr[0]);
            this.minor = Short.parseShort(arr[1]);
            this.maintenance = Short.parseShort(arr[2]);
        } else {
            AppVersion appVersion = (AppVersion)new ObjectMapper().readValue(jsonString, this.getClass());
            this.major = appVersion.major;
            this.minor = appVersion.getMinor();
            this.maintenance = appVersion.getMaintenance();
            this.build = appVersion.getBuild();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.major + ".");
        builder = builder.append(this.minor + "." + this.maintenance);
        if (StringUtils.hasText((String)this.build)) {
            builder.append("-").append(this.build);
        }
        return builder.toString();
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getMaintenance() {
        return this.maintenance;
    }

    public String getBuild() {
        return this.build;
    }

    public void setMajor(short major) {
        this.major = major;
    }

    public void setMinor(short minor) {
        this.minor = minor;
    }

    public void setMaintenance(short maintenance) {
        this.maintenance = maintenance;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppVersion)) {
            return false;
        }
        AppVersion other = (AppVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getMaintenance() != other.getMaintenance()) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getMaintenance();
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        return result;
    }

    public AppVersion(short major, short minor, short maintenance, String build) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.build = build;
    }
}

