/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.context.TenantContext;
import tech.corefinance.common.dto.JwtTokenDto;

@Component
@ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"tenant"}, havingValue="true")
public class TenantIdFilter
implements Filter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TenantIdFilter.class);
    @Value(value="${tech.corefinance.common.filter-ordered.tenant-id-filter-order:3}")
    private int order;

    public int getOrder() {
        return this.order;
    }

    public void init(FilterConfig filterConfig) {
        log.debug("Initializing trace info filter...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TenantContext tenantContext = TenantContext.getInstance();
        log.debug("Checking tenant id header [{}] in the request...", (Object)"x-tenant-id");
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String tenantId = httpServletRequest.getHeader("x-tenant-id");
            log.debug("Tenant id value in header [{}]", (Object)tenantId);
            if (StringUtils.hasText((String)tenantId)) {
                tenantContext.setTenantId(tenantId);
                httpServletResponse.setHeader("x-tenant-id", URLEncoder.encode(tenantId, StandardCharsets.US_ASCII));
                log.debug("Set tenant id [{}] to context and response.", (Object)tenantId);
                log.debug("Continue filter chain");
            } else {
                log.debug("Checking tenant id JWT in the request...");
                JwtTokenDto jwt = JwtContext.getInstance().getJwt();
                log.debug("JWT instance [{}]", (Object)jwt);
                if (jwt != null && StringUtils.hasText((String)jwt.getTenantId())) {
                    tenantId = jwt.getTenantId();
                    log.debug("Tenant id value in JWT [{}]", (Object)tenantId);
                    tenantContext.setTenantId(tenantId);
                    httpServletResponse.setHeader("x-tenant-id", URLEncoder.encode(tenantId, StandardCharsets.US_ASCII));
                    log.debug("Set tenant id [{}] to context and response.", (Object)tenantId);
                    log.debug("Continue filter chain");
                } else {
                    log.debug("No Tenant ID in request!");
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            log.debug("Clear tenant id in the context!");
            tenantContext.clearTenantId();
        }
    }

    public void destroy() {
        log.debug("Destroy trace info filter!");
    }
}

