/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="spring.jackson-custom.serialization", name={"zoned-date-time-format"})
public class ZonedDateTimeJsonDeserializer
extends JsonDeserializer<ZonedDateTime> {
    private static final Logger log = LoggerFactory.getLogger(ZonedDateTimeJsonDeserializer.class);
    private DateTimeFormatter dateTimeFormatter;

    public ZonedDateTimeJsonDeserializer(@Value(value="${spring.jackson-custom.serialization.zoned-date-time-format}") String dateTimeFormat, @Autowired ObjectMapper objectMapper) {
        log.debug("Applied {} format: {}", (Object)ZonedDateTime.class.getSimpleName(), (Object)dateTimeFormat);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimeFormat);
        SimpleModule simpleModule = new SimpleModule(ZonedDateTime.class.getSimpleName() + "DeserializerModule", new Version(1, 0, 0, null, "", ""));
        simpleModule.addDeserializer(ZonedDateTime.class, (JsonDeserializer)this);
        objectMapper.registerModule((Module)simpleModule);
    }

    public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String dateString = p.getText();
        log.debug("Parsing {} to {}", (Object)dateString, ZonedDateTime.class);
        try {
            return ZonedDateTime.parse(dateString, this.dateTimeFormatter);
        }
        catch (DateTimeParseException e) {
            log.debug("Err for " + this.dateTimeFormatter, (Throwable)e);
            return ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public String toString() {
        return "ZonedDateTimeJsonDeserializer(dateTimeFormatter=" + this.getDateTimeFormatter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZonedDateTimeJsonDeserializer)) {
            return false;
        }
        ZonedDateTimeJsonDeserializer other = (ZonedDateTimeJsonDeserializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DateTimeFormatter this$dateTimeFormatter = this.getDateTimeFormatter();
        DateTimeFormatter other$dateTimeFormatter = other.getDateTimeFormatter();
        return !(this$dateTimeFormatter == null ? other$dateTimeFormatter != null : !this$dateTimeFormatter.equals(other$dateTimeFormatter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZonedDateTimeJsonDeserializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $dateTimeFormatter = this.getDateTimeFormatter();
        result = result * 59 + ($dateTimeFormatter == null ? 43 : $dateTimeFormatter.hashCode());
        return result;
    }
}

