/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter.json;

import io.swagger.v3.oas.models.media.Schema;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalAccessorSchema<T extends TemporalAccessor>
extends Schema<T> {
    private static final Logger log = LoggerFactory.getLogger(TemporalAccessorSchema.class);
    private DateTimeFormatter dateTimeFormatter;
    private Class<T> handleClass;

    public TemporalAccessorSchema(DateTimeFormatter dateTimeFormatter, Class<T> handleClass, String dateTimeFormat) {
        super("string", "object");
        this.dateTimeFormatter = dateTimeFormatter;
        this.handleClass = handleClass;
        String currentDateAsString = dateTimeFormatter.format(ZonedDateTime.now());
        log.debug("Current date formatted [{}]", (Object)currentDateAsString);
        this.setPattern(dateTimeFormat);
        this.setExample(currentDateAsString);
    }

    public TemporalAccessorSchema<T> type(String type) {
        super.setType(type);
        return this;
    }

    public TemporalAccessorSchema<T> format(String format) {
        super.setFormat(format);
        return this;
    }

    protected T cast(Object value) {
        if (value != null) {
            try {
                if (value instanceof String) {
                    value = this.dateTimeFormatter.parse((String)value);
                }
                if (this.handleClass.isAssignableFrom(value.getClass())) {
                    return (T)((TemporalAccessor)value);
                }
            }
            catch (Exception var3) {
                log.debug("Error", (Throwable)var3);
            }
        }
        return null;
    }

    public TemporalAccessorSchema<T> _enum(List<T> _enum) {
        super.setEnum(_enum);
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemporalAccessorSchema)) {
            return false;
        }
        TemporalAccessorSchema other = (TemporalAccessorSchema)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DateTimeFormatter this$dateTimeFormatter = this.dateTimeFormatter;
        DateTimeFormatter other$dateTimeFormatter = other.dateTimeFormatter;
        if (this$dateTimeFormatter == null ? other$dateTimeFormatter != null : !this$dateTimeFormatter.equals(other$dateTimeFormatter)) {
            return false;
        }
        Class<T> this$handleClass = this.handleClass;
        Class<T> other$handleClass = other.handleClass;
        return !(this$handleClass == null ? other$handleClass != null : !this$handleClass.equals(other$handleClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemporalAccessorSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $dateTimeFormatter = this.dateTimeFormatter;
        result = result * 59 + ($dateTimeFormatter == null ? 43 : $dateTimeFormatter.hashCode());
        Class<T> $handleClass = this.handleClass;
        result = result * 59 + ($handleClass == null ? 43 : $handleClass.hashCode());
        return result;
    }

    public String toString() {
        return "TemporalAccessorSchema(dateTimeFormatter=" + this.dateTimeFormatter + ", handleClass=" + this.handleClass + ")";
    }
}

