/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.providers.SpringDocProviders;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import tech.corefinance.common.converter.json.TemporalAccessorSchema;

@Order
public abstract class TemporalAccessorJsonSerializer<T extends TemporalAccessor>
extends JsonSerializer<T>
implements InitializingBean,
ModelConverter {
    private static final Logger log = LoggerFactory.getLogger(TemporalAccessorJsonSerializer.class);
    private String dateTimeFormat;
    @Autowired
    private ObjectMapper objectMapper;
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private SpringDocProviders springDocProviders;

    public TemporalAccessorJsonSerializer(@NotNull String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @PostConstruct
    protected void postConstruct() {
        assert (this.dateTimeFormat != null) : "DateTimeFormat cannot be null";
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        log.debug("Converting value [{}]", value);
        gen.writeString(this.dateTimeFormatter.format((TemporalAccessor)value));
    }

    public void afterPropertiesSet() throws Exception {
        String handleClassName = this.handledType().getSimpleName();
        log.debug("Applied {} format: {}", (Object)handleClassName, (Object)this.dateTimeFormat);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimeFormat);
        SimpleModule simpleModule = new SimpleModule(handleClassName + "Module", new Version(1, 0, 0, null, "", ""));
        simpleModule.addSerializer((JsonSerializer)this);
        this.objectMapper.registerModule((Module)simpleModule);
        this.springDocProviders.jsonMapper().registerModule((Module)simpleModule);
    }

    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class handledType = this.handledType();
        JavaType javaType = this.springDocProviders.jsonMapper().constructType(type.getType());
        Class annotatedTypeClass = javaType.getRawClass();
        boolean isAssignable = handledType.isAssignableFrom(annotatedTypeClass);
        log.debug("handledType [{}], annotatedTypeClass [{}], isAssignable [{}]", new Object[]{handledType, annotatedTypeClass, isAssignable});
        if (isAssignable) {
            return new TemporalAccessorSchema(this.dateTimeFormatter, handledType, this.dateTimeFormat);
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public SpringDocProviders getSpringDocProviders() {
        return this.springDocProviders;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public void setSpringDocProviders(SpringDocProviders springDocProviders) {
        this.springDocProviders = springDocProviders;
    }

    public String toString() {
        return "TemporalAccessorJsonSerializer(dateTimeFormat=" + this.getDateTimeFormat() + ", objectMapper=" + this.getObjectMapper() + ", dateTimeFormatter=" + this.getDateTimeFormatter() + ", springDocProviders=" + this.getSpringDocProviders() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemporalAccessorJsonSerializer)) {
            return false;
        }
        TemporalAccessorJsonSerializer other = (TemporalAccessorJsonSerializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dateTimeFormat = this.getDateTimeFormat();
        String other$dateTimeFormat = other.getDateTimeFormat();
        if (this$dateTimeFormat == null ? other$dateTimeFormat != null : !this$dateTimeFormat.equals(other$dateTimeFormat)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        DateTimeFormatter this$dateTimeFormatter = this.getDateTimeFormatter();
        DateTimeFormatter other$dateTimeFormatter = other.getDateTimeFormatter();
        if (this$dateTimeFormatter == null ? other$dateTimeFormatter != null : !this$dateTimeFormatter.equals(other$dateTimeFormatter)) {
            return false;
        }
        SpringDocProviders this$springDocProviders = this.getSpringDocProviders();
        SpringDocProviders other$springDocProviders = other.getSpringDocProviders();
        return !(this$springDocProviders == null ? other$springDocProviders != null : !this$springDocProviders.equals(other$springDocProviders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemporalAccessorJsonSerializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dateTimeFormat = this.getDateTimeFormat();
        result = result * 59 + ($dateTimeFormat == null ? 43 : $dateTimeFormat.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        DateTimeFormatter $dateTimeFormatter = this.getDateTimeFormatter();
        result = result * 59 + ($dateTimeFormatter == null ? 43 : $dateTimeFormatter.hashCode());
        SpringDocProviders $springDocProviders = this.getSpringDocProviders();
        result = result * 59 + ($springDocProviders == null ? 43 : $springDocProviders.hashCode());
        return result;
    }
}

