/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import tech.corefinance.common.converter.CommonCustomConverter;

@Component
@ConditionalOnProperty(name={"tech.corefinance.app.converter.local-date-to-string"}, havingValue="true", matchIfMissing=true)
@ReadingConverter
public class StringToLocalDateConverter
implements GenericConverter,
CommonCustomConverter<String, LocalDate> {
    public LocalDate convert(@Nullable String document) {
        if (document == null) {
            return null;
        }
        return LocalDate.parse(document, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> result = new HashSet<GenericConverter.ConvertiblePair>();
        result.add(new GenericConverter.ConvertiblePair(String.class, LocalDate.class));
        return result;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.convert((String)source);
    }
}

