/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import tech.corefinance.common.converter.CommonCustomConverter;

@Component
@ConditionalOnProperty(name={"tech.corefinance.app.converter.zoned-date-time-to-local-date-time"}, havingValue="true", matchIfMissing=true)
@ReadingConverter
public class LocalDateTimeToZonedDateTimeConverter
implements GenericConverter,
CommonCustomConverter<LocalDateTime, ZonedDateTime> {
    public ZonedDateTime convert(@Nullable LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.of(date, ZoneId.systemDefault());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> result = new HashSet<GenericConverter.ConvertiblePair>();
        result.add(new GenericConverter.ConvertiblePair(LocalDateTime.class, ZonedDateTime.class));
        return result;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.convert((LocalDateTime)source);
    }
}

