/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.corefinance.common.annotation.ControllerManagedResource;
import tech.corefinance.common.annotation.PermissionAction;
import tech.corefinance.common.controller.CrudController;
import tech.corefinance.common.dto.GeneralApiResponse;
import tech.corefinance.common.dto.PermissionDto;
import tech.corefinance.common.model.Permission;
import tech.corefinance.common.service.CommonService;
import tech.corefinance.common.service.PermissionService;

@RestController
@RequestMapping(value={"/permissions"})
@ControllerManagedResource(value="permission")
public class PermissionController
implements CrudController<String, Permission, PermissionDto> {
    @Autowired
    private PermissionService permissionService;

    @Override
    public CommonService<String, Permission, ?> getHandlingService() {
        return this.permissionService;
    }

    @PostMapping(value={"/load-by-roles"})
    @PermissionAction(action="load_by_role")
    public GeneralApiResponse<List<Permission>> loadByRoles(@RequestBody List<String> roleIds) {
        return GeneralApiResponse.createSuccessResponse(this.permissionService.loadByRoles(roleIds));
    }

    @PutMapping(value={"/override-by-roles/{roleId}"})
    @PermissionAction(action="override_by_role")
    public GeneralApiResponse<List<Permission>> overrideByRoles(@PathVariable(value="roleId") String roleId, @RequestBody List<Permission> permissions) {
        return GeneralApiResponse.createSuccessResponse(this.permissionService.overrideByRoles(roleId, permissions));
    }
}

