/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TraceIdContext {
    private static final Logger log = LoggerFactory.getLogger(TraceIdContext.class);
    private static final TraceIdContext INSTANCE = new TraceIdContext();
    private ThreadLocal<String> traceIdThreadLocal = new InheritableThreadLocal<String>();

    private TraceIdContext() {
        log.debug("Created TraceIdContext [{}]", (Object)this);
    }

    public static TraceIdContext getInstance() {
        return INSTANCE;
    }

    public void setTraceId(String traceId) {
        this.traceIdThreadLocal.set(traceId);
    }

    public String getTraceId() {
        return this.traceIdThreadLocal.get();
    }

    public void clearTraceId() {
        this.traceIdThreadLocal.remove();
    }
}

