/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="tech.corefinance.security.jwt")
public class JwtConfiguration {
    private long expiration = 3600L;
    private int maxLoginFailAllowed;
    private String loginMode;

    public long getExpiration() {
        return this.expiration;
    }

    public int getMaxLoginFailAllowed() {
        return this.maxLoginFailAllowed;
    }

    public String getLoginMode() {
        return this.loginMode;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public void setMaxLoginFailAllowed(int maxLoginFailAllowed) {
        this.maxLoginFailAllowed = maxLoginFailAllowed;
    }

    public void setLoginMode(String loginMode) {
        this.loginMode = loginMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtConfiguration)) {
            return false;
        }
        JwtConfiguration other = (JwtConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiration() != other.getExpiration()) {
            return false;
        }
        if (this.getMaxLoginFailAllowed() != other.getMaxLoginFailAllowed()) {
            return false;
        }
        String this$loginMode = this.getLoginMode();
        String other$loginMode = other.getLoginMode();
        return !(this$loginMode == null ? other$loginMode != null : !this$loginMode.equals(other$loginMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiration = this.getExpiration();
        result = result * 59 + (int)($expiration >>> 32 ^ $expiration);
        result = result * 59 + this.getMaxLoginFailAllowed();
        String $loginMode = this.getLoginMode();
        result = result * 59 + ($loginMode == null ? 43 : $loginMode.hashCode());
        return result;
    }

    public String toString() {
        return "JwtConfiguration(expiration=" + this.getExpiration() + ", maxLoginFailAllowed=" + this.getMaxLoginFailAllowed() + ", loginMode=" + this.getLoginMode() + ")";
    }
}

