/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.servlet.LocaleResolver;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.context.StatelessLocaleResolver;
import tech.corefinance.common.context.TenantContext;
import tech.corefinance.common.context.TraceIdContext;
import tech.corefinance.common.dto.SimpleVersionComparator;

@Configuration
@ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"context"}, havingValue="true", matchIfMissing=true)
public class CommonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CommonAutoConfiguration.class);

    @Bean(name={"localeResolver"})
    @ConditionalOnMissingBean(value={LocaleResolver.class})
    public LocaleResolver getLocaleResolver() {
        log.info("Creating StatelessLocaleResolver...");
        return new StatelessLocaleResolver();
    }

    @Bean
    @ConditionalOnMissingBean(value={ApplicationContextHolder.class})
    public ApplicationContextHolder applicationContextHolder() {
        log.info("Creating ApplicationContextHolder...");
        return ApplicationContextHolder.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtContext.class})
    public JwtContext jwtContext() {
        log.info("Creating JwtContext...");
        return JwtContext.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={SimpleVersionComparator.class})
    @ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"simple-version"}, havingValue="true")
    public SimpleVersionComparator simpleVersionComparator() {
        log.info("Creating SimpleVersionComparator...");
        return new SimpleVersionComparator();
    }

    @Bean
    public PasswordEncoder getPasswordEncoder() {
        log.info("Creating BCryptPasswordEncoder...");
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"tenant"}, havingValue="true")
    public TenantContext tenantContext() {
        log.info("Creating TenantContext...");
        return TenantContext.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={TraceIdContext.class})
    public TraceIdContext traceIdContext() {
        log.info("Creating TraceIdContext...");
        return TraceIdContext.getInstance();
    }
}

