/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.audit;

import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ParameterizedTypeReference;
import tech.corefinance.common.model.ModifiedDateTrackedEntity;

@Configurable
@ConditionalOnProperty(name={"tech.corefinance.audit.enabled.zoned-date-time"}, havingValue="true", matchIfMissing=true)
public class EntityZonedDateTimeAuditListener {
    private static final Logger log = LoggerFactory.getLogger(EntityZonedDateTimeAuditListener.class);

    @PrePersist
    private void beforeInsert(Object obj) {
        log.debug("Before inserting {}", obj);
        ParameterizedTypeReference<ModifiedDateTrackedEntity<ZonedDateTime>> typeReference = new ParameterizedTypeReference<ModifiedDateTrackedEntity<ZonedDateTime>>(){};
        Class<?> modifiedZonedClass = typeReference.getType().getClass();
        if (modifiedZonedClass.isInstance(obj)) {
            ZonedDateTime now = ZonedDateTime.now();
            ModifiedDateTrackedEntity en = (ModifiedDateTrackedEntity)obj;
            if (en.getCreatedDate() == null) {
                log.debug("Setting {} to createdDate attribute.", (Object)now);
                en.setCreatedDate(now);
            } else {
                log.debug("createdDate attribute already set manually!");
            }
            log.debug("Setting {} to lastModifiedDate attribute.", (Object)now);
            en.setLastModifiedDate(now);
        } else {
            log.debug("{} is not auditable.", obj);
        }
    }

    @PreUpdate
    private void beforeUpdate(Object obj) {
        log.debug("Before updating {}", obj);
        if (obj instanceof ModifiedDateTrackedEntity) {
            ModifiedDateTrackedEntity en = (ModifiedDateTrackedEntity)obj;
            ZonedDateTime now = ZonedDateTime.now();
            log.debug("Setting {} to lastModifiedDate attribute.", (Object)now);
            en.setLastModifiedDate(now);
        } else {
            log.debug("{} is not auditable.", obj);
        }
    }
}

