/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Proxy;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import tech.corefinance.common.util.CoreFinanceUtil;

public abstract class MethodDataLoging {
    @Autowired
    protected CoreFinanceUtil coreFinanceUtil;
    @Autowired
    protected ObjectMapper objectMapper;
    private List<String> excludeClasses;

    protected abstract Logger getLog();

    public MethodDataLoging(List<String> excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    protected String getLogingStartMark() {
        return "========================";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doLogging(ProceedingJoinPoint joinPoint) throws Throwable {
        Object unProxyObj;
        Logger log = this.getLog();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String startMark = this.getLogingStartMark();
        Object target = joinPoint.getTarget();
        Class<?> targetClass = target.getClass();
        log.debug("Target class [{}]", targetClass);
        if (Proxy.isProxyClass(targetClass) && (unProxyObj = this.coreFinanceUtil.unProxy(target)) != null) {
            targetClass = unProxyObj.getClass();
            log.debug("UnProxy target class [{}]", targetClass);
            if (this.coreFinanceUtil.isMatchedInstanceType(unProxyObj, this.excludeClasses)) {
                log.debug("Excluded for [{}]", unProxyObj);
                return joinPoint.proceed();
            }
        }
        StringBuilder msg = new StringBuilder(startMark).append(targetClass.getSimpleName()).append("#").append(signature.getName()).append(startMark + " <= ");
        int length = msg.length();
        long start = 0L;
        long end = 0L;
        try {
            msg.append("START");
            log.info(msg.toString());
            String[] parametersNames = signature.getParameterNames();
            String input = this.coreFinanceUtil.buildMethodInputJsonLog(joinPoint, parametersNames, this.objectMapper);
            log.info("Input [{}]", (Object)input);
            this.doAdditionalInputLog(joinPoint, this.objectMapper);
            start = System.currentTimeMillis();
            Class returnType = signature.getReturnType();
            log.info("Return type {}", (Object)returnType);
            Object result = joinPoint.proceed();
            end = System.currentTimeMillis();
            if (!Void.TYPE.isAssignableFrom(returnType)) {
                log.debug("Result: {}", (Object)this.coreFinanceUtil.writeValueToJson(this.objectMapper, result));
            }
            Object object = result;
            return object;
        }
        finally {
            if (end == 0L) {
                end = System.currentTimeMillis();
            }
            msg.setLength(length);
            msg.append("  END in [").append(end - start).append("] ms.");
            log.info(msg.toString());
        }
    }

    protected void doAdditionalInputLog(ProceedingJoinPoint joinPoint, ObjectMapper objectMapper) {
    }
}

