/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.account.common.service;

import java.util.LinkedList;
import java.util.List;
import tech.corefinance.account.common.dto.TransactionRequest;
import tech.corefinance.account.common.entity.AccountTransaction;
import tech.corefinance.account.common.model.TransactionFee;
import tech.corefinance.account.common.service.AccountTransactionService;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.repository.CommonResourceRepository;

public abstract class AccountTransactionServiceImpl<T extends AccountTransaction, R extends CommonResourceRepository<T, String>>
implements AccountTransactionService<T, R> {
    public <D extends CreateUpdateDto<String>> T copyAdditionalPropertiesFromDtoToEntity(D source, T dest) {
        dest = (AccountTransaction)AccountTransactionService.super.copyAdditionalPropertiesFromDtoToEntity(source, dest);
        if (source instanceof TransactionRequest) {
            TransactionRequest tranRequest = (TransactionRequest)source;
            List<TransactionFee> fees = tranRequest.getTransactionFees();
            if (fees != null) {
                for (TransactionFee fee : fees) {
                    fee.setTotal(fee.getAmount() + fee.getVat());
                }
            } else {
                ((AccountTransaction)dest).setTransactionFees(new LinkedList<TransactionFee>());
            }
        }
        return (T)dest;
    }
}

