/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.account.common.service;

import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import tech.corefinance.account.common.config.AccountKafkaConfig;
import tech.corefinance.account.common.dto.BalanceCleanupMessage;
import tech.corefinance.account.common.dto.BalanceInitialMessage;
import tech.corefinance.account.common.entity.Account;
import tech.corefinance.account.common.model.AccountType;
import tech.corefinance.account.common.service.AccountService;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.dto.JwtTokenDto;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.jpa.repository.DbSequenceHandling;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.repository.CommonResourceRepository;
import tech.corefinance.common.util.RandomString;
import tech.corefinance.product.common.model.ProductNewAccountSetting;
import tech.corefinance.product.common.model.ProductNewAccountSettingType;

public abstract class AccountServiceImpl<T extends Account, R extends CommonResourceRepository<T, String>>
implements AccountService<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    protected Random random = new Random();
    protected int maxRandomIdCheck;
    protected TaskExecutor taskExecutor;
    protected DbSequenceHandling dbSequenceHandling;
    private KafkaTemplate<String, Object> kafkaTemplate;
    private AccountKafkaConfig accountKafkaConfig;

    public AccountServiceImpl(int maxRandomIdCheck, TaskExecutor taskExecutor, DbSequenceHandling dbSequenceHandling, KafkaTemplate<String, Object> kafkaTemplate, AccountKafkaConfig accountKafkaConfig) {
        this.maxRandomIdCheck = maxRandomIdCheck;
        this.taskExecutor = taskExecutor;
        this.dbSequenceHandling = dbSequenceHandling;
        this.kafkaTemplate = kafkaTemplate;
        this.accountKafkaConfig = accountKafkaConfig;
    }

    protected abstract Object getCategoryObject(String var1);

    protected abstract Object getTypeObject(String var1);

    protected abstract Object getProductObject(String var1);

    protected abstract String getSequenceName();

    public <D extends CreateUpdateDto<String>> T copyAdditionalPropertiesFromDtoToEntity(D source, T dest) {
        if (!StringUtils.hasText((String)((Account)(dest = (Account)AccountService.super.copyAdditionalPropertiesFromDtoToEntity(source, dest))).getId())) {
            ((Account)dest).setCreatedDate(ZonedDateTime.now());
            ((Account)dest).setLastModifiedDate(ZonedDateTime.now());
        }
        String productId = ((Account)dest).getProductId();
        log.debug("Getting product [{}]...", (Object)productId);
        Object productResult = this.getProductObject(productId);
        log.debug("Product [{}]", productResult);
        return (T)this.mapProductToAccount(source, productResult, dest);
    }

    private Object retrieveFieldName(Object obj, String fieldName) {
        Field field;
        if (obj != null && (field = ReflectionUtils.findField(obj.getClass(), (String)fieldName)) != null) {
            field.setAccessible(true);
            try {
                return field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new ServiceProcessingException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String generateAccountId(ProductNewAccountSetting newAccountSetting) {
        return switch (newAccountSetting.getType()) {
            case ProductNewAccountSettingType.INCREASEMENT -> this.generateIncrementalId(newAccountSetting);
            case ProductNewAccountSettingType.RANDOM_PATTERN -> this.generateRandomId(newAccountSetting);
            default -> UUID.randomUUID().toString();
        };
    }

    private String generateIncrementalId(ProductNewAccountSetting newAccountSetting) {
        String sequenceName = this.getSequenceName();
        log.debug("Generating incremental ID from sequence [{}]...", (Object)sequenceName);
        Long currentStarting = this.dbSequenceHandling.getCurrentSequenceValue(sequenceName);
        log.debug("Current sequence [{}]", (Object)currentStarting);
        if (currentStarting < (long)newAccountSetting.getIncreasementStartingFrom()) {
            this.dbSequenceHandling.restartSequence((long)newAccountSetting.getIncreasementStartingFrom(), sequenceName);
            log.debug("Restarted new value [{}]", (Object)newAccountSetting.getIncreasementStartingFrom());
        }
        currentStarting = this.dbSequenceHandling.getNextSequenceValue(sequenceName);
        log.debug("New sequence value [{}]", (Object)currentStarting);
        StringBuilder result = new StringBuilder("" + currentStarting);
        if (newAccountSetting.isFixLengthId()) {
            int accountLength = result.length();
            log.debug("Trying to append length to [{}]", (Object)accountLength);
            if (accountLength > newAccountSetting.getFixAccountLength()) {
                throw new ServiceProcessingException("invalid_product_setting_account_length");
            }
            while (accountLength < newAccountSetting.getFixAccountLength()) {
                result.insert(0, "0");
                accountLength = result.length();
            }
            log.debug("Finished append 0 and final is [{}]", (Object)result);
        }
        if (newAccountSetting.getIdPrefix() != null) {
            result.insert(0, newAccountSetting.getIdPrefix());
            log.debug("Append prefix [{}]", (Object)result);
        }
        if (newAccountSetting.getIdSuffix() != null) {
            result.append(newAccountSetting.getIdSuffix());
            log.debug("Append suffix [{}]", (Object)result);
        }
        log.debug("Final account ID [{}]", (Object)result);
        return result.toString();
    }

    private String generateRandomId(ProductNewAccountSetting newAccountSetting) {
        CommonResourceRepository repository = this.getRepository();
        log.debug("Generating random ID...");
        String result = this.nextRandomId(newAccountSetting);
        log.debug("Generated random ID [{}]", (Object)result);
        int duplicatedCount = 0;
        while (repository.existsById((Object)result)) {
            log.debug("Generated random ID [{}] is existed!", (Object)result);
            if (duplicatedCount >= this.maxRandomIdCheck) {
                throw new ServiceProcessingException("account_id_gen_duplicated");
            }
            ++duplicatedCount;
            log.debug("Generated random ID [{}]", (Object)result);
            result = this.nextRandomId(newAccountSetting);
        }
        log.debug("Final account ID [{}]", (Object)result);
        return result;
    }

    private String nextRandomId(ProductNewAccountSetting newAccountSetting) {
        StringBuilder result = new StringBuilder();
        String template = newAccountSetting.getRandomPatternTemplate();
        RandomString charRandom = new RandomString(1, this.random, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        RandomString numRandom = new RandomString(1, this.random, "0123456789");
        RandomString alphaNumRandom = new RandomString(1, this.random, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            result.append(switch (c) {
                case '@' -> charRandom.nextString();
                case '#' -> numRandom.nextString();
                case '$' -> alphaNumRandom.nextString();
                default -> Character.valueOf(c);
            });
        }
        return result.toString();
    }

    protected <D extends CreateUpdateDto<String>> T mapProductToAccount(D source, Object productObject, T dest) {
        ProductNewAccountSetting newAccountSetting = (ProductNewAccountSetting)this.retrieveFieldName(productObject, "newAccountSetting");
        log.debug("New Account setting [{}]", (Object)newAccountSetting);
        if (!StringUtils.hasText((String)((Account)dest).getId())) {
            ((Account)dest).setCreatedBy((BasicUserDto)null);
            if (newAccountSetting != null) {
                ((Account)dest).setStatus(newAccountSetting.getInitialState());
                ((Account)dest).setId(this.generateAccountId(newAccountSetting));
            }
        }
        JwtTokenDto jwtTokenDto = JwtContext.getInstance().getJwt();
        LinkedList tasks = new LinkedList();
        tasks.add(CompletableFuture.supplyAsync(() -> {
            JwtContext.getInstance().setJwt(jwtTokenDto);
            String categoryId = (String)this.retrieveFieldName(productObject, "category");
            dest.setCategoryId(categoryId);
            log.debug("Getting category [{}]...", (Object)categoryId);
            Object categoryResult = this.getCategoryObject(categoryId);
            log.debug("Category [{}]", categoryResult);
            Object name = this.retrieveFieldName(categoryResult, "name");
            log.debug("Retrieved name [{}]", name);
            if (name != null) {
                dest.setCategoryName((String)name);
                log.debug("Finished setting name [{}] to result", name);
            }
            return categoryResult;
        }, (Executor)this.taskExecutor));
        tasks.add(CompletableFuture.supplyAsync(() -> {
            JwtContext.getInstance().setJwt(jwtTokenDto);
            String typeId = (String)this.retrieveFieldName(productObject, "type");
            dest.setTypeId(typeId);
            log.debug("Getting type [{}]...", (Object)typeId);
            Object typeResult = this.getTypeObject(typeId);
            log.debug("Type [{}]", typeResult);
            Object name = this.retrieveFieldName(typeResult, "name");
            log.debug("Retrieved name [{}]", name);
            if (name != null) {
                dest.setTypeName((String)name);
                log.debug("Finished setting name [{}] to result", name);
            }
            return typeResult;
        }, (Executor)this.taskExecutor));
        List<CompletableFuture<?>> customTasks = this.addAsyncTaskCreateUpdateAccount();
        tasks.addAll(customTasks);
        for (CompletableFuture completableFuture : tasks) {
            completableFuture.join();
        }
        return dest;
    }

    protected List<CompletableFuture<?>> addAsyncTaskCreateUpdateAccount() {
        return new LinkedList();
    }

    public void afterEntitySaved(T entity) {
        AccountService.super.afterEntitySaved(entity);
        BalanceInitialMessage balanceInitialMessage = new BalanceInitialMessage();
        balanceInitialMessage.setAccountId(((Account)entity).getId());
        AccountType accountType = this.getAccountType(entity);
        balanceInitialMessage.setAccountType(accountType);
        balanceInitialMessage.setSupportedCurrencies(((Account)entity).getSupportedCurrencies());
        log.debug("Sending balance initial message [{}]", (Object)balanceInitialMessage);
        this.kafkaTemplate.send(this.accountKafkaConfig.getBalancesInitTopic(), (Object)balanceInitialMessage).join();
        log.debug("Sent balance initial message [{}]", (Object)balanceInitialMessage);
    }

    public void afterItemDeleted(T item) {
        AccountService.super.afterItemDeleted(item);
        BalanceCleanupMessage cleanupMessage = new BalanceCleanupMessage();
        cleanupMessage.setAccountType(this.getAccountType(item));
        cleanupMessage.setAccountId(((Account)item).getId());
        log.debug("Sending balance cleanup message [{}]", (Object)cleanupMessage);
        this.kafkaTemplate.send(this.accountKafkaConfig.getBalancesCleanupTopic(), (Object)cleanupMessage).join();
        log.debug("Sent balance cleanup message [{}]", (Object)cleanupMessage);
    }

    private AccountType getAccountType(T account) {
        return switch (account.getClass().getSimpleName()) {
            case "GlAccount" -> AccountType.GL;
            case "CryptoAccount" -> AccountType.CRYPTO;
            case "LoanAccount" -> AccountType.LOAN;
            default -> AccountType.DEPOSIT;
        };
    }
}

