/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.account.common.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.time.ZonedDateTime;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import tech.corefinance.account.common.enums.CustomerType;
import tech.corefinance.account.common.model.TransactionFee;
import tech.corefinance.account.common.model.TransactionSide;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.model.ModifiedDateTrackedEntity;

@MappedSuperclass
public class AccountTransaction
implements GenericModel<String>,
ModifiedDateTrackedEntity<ZonedDateTime> {
    @Id
    private String id;
    @Column(name="trans_date")
    private ZonedDateTime transDate;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    private double amount;
    private double vat;
    @Column(name="total_amount")
    private double totalAmount;
    private String currency;
    @Column(name="target_currency")
    private String targetCurrency;
    @Column(name="transaction_fees")
    @JdbcTypeCode(value=3001)
    private List<TransactionFee> transactionFees;
    @Column(name="total_fee_amount")
    private double totalFeeAmount;
    @Column(name="total_fee_vat_amount")
    private double totalFeeVatAmount;
    @Column(name="total_fee_vat_and_fee_amount")
    private double totalFeeVatAndFeeAmount;
    @Enumerated(value=EnumType.STRING)
    @Column(name="transaction_side")
    private TransactionSide transactionSide;
    @Column(name="before_tran_amount")
    private double beforeTranAmount;
    @Column(name="after_tran_amount")
    private double afterTranAmount;
    @Column(name="applied_exchange_rate")
    private double appliedExchangeRate;
    private String memo;
    @Column(name="counter_account_id")
    private String counterAccountId;
    @Column(name="counter_customer_type")
    @Enumerated(value=EnumType.STRING)
    private CustomerType counterCustomerType;
    @Column(name="counter_customer_id")
    private long counterCustomerId;
    @Column(name="counter_account_type")
    private String counterAccountType;
    @Column(name="transaction_type")
    private String transactionType;
    @Column(name="transaction_code")
    private String transactionCode;
    @Column(name="terminal_id")
    private String terminalId;
    @Column(name="request_app_id")
    private String requestAppId;
    @Column(name="request_channel_id")
    private String requestChannelId;

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getTransDate() {
        return this.transDate;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getVat() {
        return this.vat;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public List<TransactionFee> getTransactionFees() {
        return this.transactionFees;
    }

    public double getTotalFeeAmount() {
        return this.totalFeeAmount;
    }

    public double getTotalFeeVatAmount() {
        return this.totalFeeVatAmount;
    }

    public double getTotalFeeVatAndFeeAmount() {
        return this.totalFeeVatAndFeeAmount;
    }

    public TransactionSide getTransactionSide() {
        return this.transactionSide;
    }

    public double getBeforeTranAmount() {
        return this.beforeTranAmount;
    }

    public double getAfterTranAmount() {
        return this.afterTranAmount;
    }

    public double getAppliedExchangeRate() {
        return this.appliedExchangeRate;
    }

    public String getMemo() {
        return this.memo;
    }

    public String getCounterAccountId() {
        return this.counterAccountId;
    }

    public CustomerType getCounterCustomerType() {
        return this.counterCustomerType;
    }

    public long getCounterCustomerId() {
        return this.counterCustomerId;
    }

    public String getCounterAccountType() {
        return this.counterAccountType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public String getRequestAppId() {
        return this.requestAppId;
    }

    public String getRequestChannelId() {
        return this.requestChannelId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTransDate(ZonedDateTime transDate) {
        this.transDate = transDate;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setVat(double vat) {
        this.vat = vat;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public void setTransactionFees(List<TransactionFee> transactionFees) {
        this.transactionFees = transactionFees;
    }

    public void setTotalFeeAmount(double totalFeeAmount) {
        this.totalFeeAmount = totalFeeAmount;
    }

    public void setTotalFeeVatAmount(double totalFeeVatAmount) {
        this.totalFeeVatAmount = totalFeeVatAmount;
    }

    public void setTotalFeeVatAndFeeAmount(double totalFeeVatAndFeeAmount) {
        this.totalFeeVatAndFeeAmount = totalFeeVatAndFeeAmount;
    }

    public void setTransactionSide(TransactionSide transactionSide) {
        this.transactionSide = transactionSide;
    }

    public void setBeforeTranAmount(double beforeTranAmount) {
        this.beforeTranAmount = beforeTranAmount;
    }

    public void setAfterTranAmount(double afterTranAmount) {
        this.afterTranAmount = afterTranAmount;
    }

    public void setAppliedExchangeRate(double appliedExchangeRate) {
        this.appliedExchangeRate = appliedExchangeRate;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setCounterAccountId(String counterAccountId) {
        this.counterAccountId = counterAccountId;
    }

    public void setCounterCustomerType(CustomerType counterCustomerType) {
        this.counterCustomerType = counterCustomerType;
    }

    public void setCounterCustomerId(long counterCustomerId) {
        this.counterCustomerId = counterCustomerId;
    }

    public void setCounterAccountType(String counterAccountType) {
        this.counterAccountType = counterAccountType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public void setRequestAppId(String requestAppId) {
        this.requestAppId = requestAppId;
    }

    public void setRequestChannelId(String requestChannelId) {
        this.requestChannelId = requestChannelId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountTransaction)) {
            return false;
        }
        AccountTransaction other = (AccountTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getVat(), other.getVat()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalAmount(), other.getTotalAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalFeeAmount(), other.getTotalFeeAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalFeeVatAmount(), other.getTotalFeeVatAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalFeeVatAndFeeAmount(), other.getTotalFeeVatAndFeeAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeforeTranAmount(), other.getBeforeTranAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getAfterTranAmount(), other.getAfterTranAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getAppliedExchangeRate(), other.getAppliedExchangeRate()) != 0) {
            return false;
        }
        if (this.getCounterCustomerId() != other.getCounterCustomerId()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ZonedDateTime this$transDate = this.getTransDate();
        ZonedDateTime other$transDate = other.getTransDate();
        if (this$transDate == null ? other$transDate != null : !((Object)this$transDate).equals(other$transDate)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$targetCurrency = this.getTargetCurrency();
        String other$targetCurrency = other.getTargetCurrency();
        if (this$targetCurrency == null ? other$targetCurrency != null : !this$targetCurrency.equals(other$targetCurrency)) {
            return false;
        }
        List<TransactionFee> this$transactionFees = this.getTransactionFees();
        List<TransactionFee> other$transactionFees = other.getTransactionFees();
        if (this$transactionFees == null ? other$transactionFees != null : !((Object)this$transactionFees).equals(other$transactionFees)) {
            return false;
        }
        TransactionSide this$transactionSide = this.getTransactionSide();
        TransactionSide other$transactionSide = other.getTransactionSide();
        if (this$transactionSide == null ? other$transactionSide != null : !((Object)((Object)this$transactionSide)).equals((Object)other$transactionSide)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        String this$counterAccountId = this.getCounterAccountId();
        String other$counterAccountId = other.getCounterAccountId();
        if (this$counterAccountId == null ? other$counterAccountId != null : !this$counterAccountId.equals(other$counterAccountId)) {
            return false;
        }
        CustomerType this$counterCustomerType = this.getCounterCustomerType();
        CustomerType other$counterCustomerType = other.getCounterCustomerType();
        if (this$counterCustomerType == null ? other$counterCustomerType != null : !((Object)((Object)this$counterCustomerType)).equals((Object)other$counterCustomerType)) {
            return false;
        }
        String this$counterAccountType = this.getCounterAccountType();
        String other$counterAccountType = other.getCounterAccountType();
        if (this$counterAccountType == null ? other$counterAccountType != null : !this$counterAccountType.equals(other$counterAccountType)) {
            return false;
        }
        String this$transactionType = this.getTransactionType();
        String other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) {
            return false;
        }
        String this$transactionCode = this.getTransactionCode();
        String other$transactionCode = other.getTransactionCode();
        if (this$transactionCode == null ? other$transactionCode != null : !this$transactionCode.equals(other$transactionCode)) {
            return false;
        }
        String this$terminalId = this.getTerminalId();
        String other$terminalId = other.getTerminalId();
        if (this$terminalId == null ? other$terminalId != null : !this$terminalId.equals(other$terminalId)) {
            return false;
        }
        String this$requestAppId = this.getRequestAppId();
        String other$requestAppId = other.getRequestAppId();
        if (this$requestAppId == null ? other$requestAppId != null : !this$requestAppId.equals(other$requestAppId)) {
            return false;
        }
        String this$requestChannelId = this.getRequestChannelId();
        String other$requestChannelId = other.getRequestChannelId();
        return !(this$requestChannelId == null ? other$requestChannelId != null : !this$requestChannelId.equals(other$requestChannelId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $vat = Double.doubleToLongBits(this.getVat());
        result = result * 59 + (int)($vat >>> 32 ^ $vat);
        long $totalAmount = Double.doubleToLongBits(this.getTotalAmount());
        result = result * 59 + (int)($totalAmount >>> 32 ^ $totalAmount);
        long $totalFeeAmount = Double.doubleToLongBits(this.getTotalFeeAmount());
        result = result * 59 + (int)($totalFeeAmount >>> 32 ^ $totalFeeAmount);
        long $totalFeeVatAmount = Double.doubleToLongBits(this.getTotalFeeVatAmount());
        result = result * 59 + (int)($totalFeeVatAmount >>> 32 ^ $totalFeeVatAmount);
        long $totalFeeVatAndFeeAmount = Double.doubleToLongBits(this.getTotalFeeVatAndFeeAmount());
        result = result * 59 + (int)($totalFeeVatAndFeeAmount >>> 32 ^ $totalFeeVatAndFeeAmount);
        long $beforeTranAmount = Double.doubleToLongBits(this.getBeforeTranAmount());
        result = result * 59 + (int)($beforeTranAmount >>> 32 ^ $beforeTranAmount);
        long $afterTranAmount = Double.doubleToLongBits(this.getAfterTranAmount());
        result = result * 59 + (int)($afterTranAmount >>> 32 ^ $afterTranAmount);
        long $appliedExchangeRate = Double.doubleToLongBits(this.getAppliedExchangeRate());
        result = result * 59 + (int)($appliedExchangeRate >>> 32 ^ $appliedExchangeRate);
        long $counterCustomerId = this.getCounterCustomerId();
        result = result * 59 + (int)($counterCustomerId >>> 32 ^ $counterCustomerId);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ZonedDateTime $transDate = this.getTransDate();
        result = result * 59 + ($transDate == null ? 43 : ((Object)$transDate).hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $targetCurrency = this.getTargetCurrency();
        result = result * 59 + ($targetCurrency == null ? 43 : $targetCurrency.hashCode());
        List<TransactionFee> $transactionFees = this.getTransactionFees();
        result = result * 59 + ($transactionFees == null ? 43 : ((Object)$transactionFees).hashCode());
        TransactionSide $transactionSide = this.getTransactionSide();
        result = result * 59 + ($transactionSide == null ? 43 : ((Object)((Object)$transactionSide)).hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        String $counterAccountId = this.getCounterAccountId();
        result = result * 59 + ($counterAccountId == null ? 43 : $counterAccountId.hashCode());
        CustomerType $counterCustomerType = this.getCounterCustomerType();
        result = result * 59 + ($counterCustomerType == null ? 43 : ((Object)((Object)$counterCustomerType)).hashCode());
        String $counterAccountType = this.getCounterAccountType();
        result = result * 59 + ($counterAccountType == null ? 43 : $counterAccountType.hashCode());
        String $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
        String $transactionCode = this.getTransactionCode();
        result = result * 59 + ($transactionCode == null ? 43 : $transactionCode.hashCode());
        String $terminalId = this.getTerminalId();
        result = result * 59 + ($terminalId == null ? 43 : $terminalId.hashCode());
        String $requestAppId = this.getRequestAppId();
        result = result * 59 + ($requestAppId == null ? 43 : $requestAppId.hashCode());
        String $requestChannelId = this.getRequestChannelId();
        result = result * 59 + ($requestChannelId == null ? 43 : $requestChannelId.hashCode());
        return result;
    }

    public String toString() {
        return "AccountTransaction(id=" + this.getId() + ", transDate=" + this.getTransDate() + ", createdDate=" + this.getCreatedDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", amount=" + this.getAmount() + ", vat=" + this.getVat() + ", totalAmount=" + this.getTotalAmount() + ", currency=" + this.getCurrency() + ", targetCurrency=" + this.getTargetCurrency() + ", transactionFees=" + this.getTransactionFees() + ", totalFeeAmount=" + this.getTotalFeeAmount() + ", totalFeeVatAmount=" + this.getTotalFeeVatAmount() + ", totalFeeVatAndFeeAmount=" + this.getTotalFeeVatAndFeeAmount() + ", transactionSide=" + this.getTransactionSide() + ", beforeTranAmount=" + this.getBeforeTranAmount() + ", afterTranAmount=" + this.getAfterTranAmount() + ", appliedExchangeRate=" + this.getAppliedExchangeRate() + ", memo=" + this.getMemo() + ", counterAccountId=" + this.getCounterAccountId() + ", counterCustomerType=" + this.getCounterCustomerType() + ", counterCustomerId=" + this.getCounterCustomerId() + ", counterAccountType=" + this.getCounterAccountType() + ", transactionType=" + this.getTransactionType() + ", transactionCode=" + this.getTransactionCode() + ", terminalId=" + this.getTerminalId() + ", requestAppId=" + this.getRequestAppId() + ", requestChannelId=" + this.getRequestChannelId() + ")";
    }
}

