/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.account.common.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotBlank;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.model.AuditableEntity;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.model.ModifiedDateTrackedEntity;
import tech.corefinance.product.common.enums.AccountState;

@MappedSuperclass
public class Account
implements GenericModel<String>,
AuditableEntity<BasicUserDto>,
ModifiedDateTrackedEntity<ZonedDateTime> {
    @Id
    private String id;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;
    @CreatedBy
    @Column(name="created_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto createdBy;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedBy
    @Column(name="last_modified_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto lastModifiedBy;
    @NotBlank(message="account_name_empty")
    private @NotBlank(message="account_name_empty") String name;
    @NotBlank(message="product_category_empty")
    @Column(name="category_id")
    private @NotBlank(message="product_category_empty") String categoryId;
    @Column(name="category_name")
    private String categoryName;
    @Column(name="type_id")
    private String typeId;
    @Column(name="type_name")
    private String typeName;
    private String description;
    @Enumerated(value=EnumType.STRING)
    private AccountState status;
    @Column(name="supported_currencies")
    private String[] supportedCurrencies;
    @Column(name="main_currency")
    private String mainCurrency;
    @Column(name="product_id")
    private String productId;

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public BasicUserDto getCreatedBy() {
        return this.createdBy;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BasicUserDto getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getName() {
        return this.name;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public AccountState getStatus() {
        return this.status;
    }

    public String[] getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    public String getMainCurrency() {
        return this.mainCurrency;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedBy(BasicUserDto createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastModifiedBy(BasicUserDto lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(AccountState status) {
        this.status = status;
    }

    public void setSupportedCurrencies(String[] supportedCurrencies) {
        this.supportedCurrencies = supportedCurrencies;
    }

    public void setMainCurrency(String mainCurrency) {
        this.mainCurrency = mainCurrency;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        BasicUserDto this$createdBy = this.getCreatedBy();
        BasicUserDto other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        BasicUserDto this$lastModifiedBy = this.getLastModifiedBy();
        BasicUserDto other$lastModifiedBy = other.getLastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$categoryId = this.getCategoryId();
        String other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !this$categoryId.equals(other$categoryId)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        if (this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName)) {
            return false;
        }
        String this$typeId = this.getTypeId();
        String other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AccountState this$status = this.getStatus();
        AccountState other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSupportedCurrencies(), other.getSupportedCurrencies())) {
            return false;
        }
        String this$mainCurrency = this.getMainCurrency();
        String other$mainCurrency = other.getMainCurrency();
        if (this$mainCurrency == null ? other$mainCurrency != null : !this$mainCurrency.equals(other$mainCurrency)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        return !(this$productId == null ? other$productId != null : !this$productId.equals(other$productId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        BasicUserDto $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        BasicUserDto $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : $categoryId.hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        String $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 43 : $typeId.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AccountState $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSupportedCurrencies());
        String $mainCurrency = this.getMainCurrency();
        result = result * 59 + ($mainCurrency == null ? 43 : $mainCurrency.hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        return result;
    }

    public String toString() {
        return "Account(id=" + this.getId() + ", createdDate=" + this.getCreatedDate() + ", createdBy=" + this.getCreatedBy() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", lastModifiedBy=" + this.getLastModifiedBy() + ", name=" + this.getName() + ", categoryId=" + this.getCategoryId() + ", categoryName=" + this.getCategoryName() + ", typeId=" + this.getTypeId() + ", typeName=" + this.getTypeName() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", supportedCurrencies=" + Arrays.deepToString(this.getSupportedCurrencies()) + ", mainCurrency=" + this.getMainCurrency() + ", productId=" + this.getProductId() + ")";
    }
}

