/*
 * Decompiled with CFR 0.152.
 */
package tech.coner.crispyfish.filetype.staging;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.coner.crispyfish.filetype.staging.StagingFileAssistant;
import tech.coner.crispyfish.filetype.staging.StagingLineException;
import tech.coner.crispyfish.filetype.staging.StagingLineModelReader$WhenMappings;
import tech.coner.crispyfish.filetype.staging.StagingLineReader;
import tech.coner.crispyfish.model.PenaltyType;
import tech.coner.crispyfish.model.Run;
import tech.coner.crispyfish.model.StagingLineRegistration;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltech/coner/crispyfish/filetype/staging/StagingLineModelReader;", "L", "", "stagingFileAssistant", "Ltech/coner/crispyfish/filetype/staging/StagingFileAssistant;", "stagingLineReader", "Ltech/coner/crispyfish/filetype/staging/StagingLineReader;", "(Ltech/coner/crispyfish/filetype/staging/StagingFileAssistant;Ltech/coner/crispyfish/filetype/staging/StagingLineReader;)V", "readRegistration", "Ltech/coner/crispyfish/model/StagingLineRegistration;", "stagingLine", "(Ljava/lang/Object;)Ltech/coner/crispyfish/model/StagingLineRegistration;", "readRun", "Ltech/coner/crispyfish/model/Run;", "stagingFileLine", "(Ljava/lang/Object;)Ltech/coner/crispyfish/model/Run;", "crispyfish-library"})
public final class StagingLineModelReader<L> {
    private final StagingFileAssistant stagingFileAssistant;
    private final StagingLineReader<L> stagingLineReader;

    @Nullable
    public final StagingLineRegistration readRegistration(L stagingLine) {
        StagingLineRegistration stagingLineRegistration;
        String string;
        boolean bl;
        CharSequence charSequence;
        String string2 = this.stagingLineReader.getRegisteredDriverNumber(stagingLine);
        String string3 = this.stagingLineReader.getRegisteredDriverClass(stagingLine);
        if (string3 != null) {
            charSequence = string3;
            bl = false;
            String string4 = charSequence;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        } else {
            string = null;
        }
        StagingLineRegistration registration = new StagingLineRegistration(string2, string, this.stagingLineReader.getRegisteredDriverName(stagingLine), this.stagingLineReader.getRegisteredDriverCar(stagingLine), this.stagingLineReader.getRegisteredDriverCarColor(stagingLine));
        charSequence = registration.getNumber();
        bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            stagingLineRegistration = null;
        } else {
            charSequence = registration.getClassing();
            bl = false;
            bl2 = false;
            stagingLineRegistration = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : registration;
        }
        return stagingLineRegistration;
    }

    @Nullable
    public final Run readRun(L stagingFileLine) {
        String raw = this.stagingLineReader.getRunRawTime(stagingFileLine);
        String pax = this.stagingLineReader.getRunPaxTime(stagingFileLine);
        String penalty = this.stagingLineReader.getRunPenalty(stagingFileLine);
        try {
            Integer n;
            Duration duration;
            Duration runRawTime = this.stagingFileAssistant.convertStagingTimeStringToDuration(raw);
            PenaltyType runPenaltyType = this.stagingFileAssistant.convertStagingRunPenaltyStringToPenaltyType(penalty);
            try {
                duration = this.stagingFileAssistant.convertStagingTimeStringToDuration(pax);
            }
            catch (StagingLineException e) {
                switch (StagingLineModelReader$WhenMappings.$EnumSwitchMapping$0[runPenaltyType.ordinal()]) {
                    case 1: {
                        throw (Throwable)new StagingLineException("Unable to parse pax time from coned run", e);
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        throw (Throwable)new StagingLineException("Unable to parse pax time from clean run", e);
                    }
                }
                duration = null;
            }
            Duration runPaxTime = duration;
            if (runPenaltyType == PenaltyType.CONE) {
                String string = penalty;
                Intrinsics.checkNotNull((Object)string);
                n = this.stagingFileAssistant.convertStagingRunPenaltyStringToConeCount(string);
            } else {
                n = runPenaltyType == PenaltyType.CLEAN ? Integer.valueOf(0) : null;
            }
            Integer runCones = n;
            String string = this.stagingLineReader.getRunNumber(stagingFileLine);
            return new Run(string != null ? StringsKt.toIntOrNull((String)string) : null, runRawTime, runPaxTime, runPenaltyType, runCones, null, raw, this.stagingFileAssistant.convertStagingTimeStringToDuration(raw));
        }
        catch (StagingLineException e) {
            return null;
        }
    }

    public StagingLineModelReader(@NotNull StagingFileAssistant stagingFileAssistant, @NotNull StagingLineReader<L> stagingLineReader) {
        Intrinsics.checkNotNullParameter((Object)stagingFileAssistant, (String)"stagingFileAssistant");
        Intrinsics.checkNotNullParameter(stagingLineReader, (String)"stagingLineReader");
        this.stagingFileAssistant = stagingFileAssistant;
        this.stagingLineReader = stagingLineReader;
    }
}

