/*
 * Decompiled with CFR 0.152.
 */
package tech.coner.crispyfish.filetype.staging;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ltech/coner/crispyfish/filetype/staging/StagingFilenameFilter;", "Ljava/io/FilenameFilter;", "eventFileOriginalStagingBaseName", "", "originalFilePattern", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;Ljava/util/regex/Pattern;)V", "getEventFileOriginalStagingBaseName", "()Ljava/lang/String;", "getOriginalFilePattern", "()Ljava/util/regex/Pattern;", "accept", "", "dir", "Ljava/io/File;", "name", "crispyfish-library"})
public final class StagingFilenameFilter
implements FilenameFilter {
    @NotNull
    private final String eventFileOriginalStagingBaseName;
    @NotNull
    private final Pattern originalFilePattern;

    @Override
    public boolean accept(@NotNull File dir, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (name == null) {
            return false;
        }
        String baseName = FilesKt.getNameWithoutExtension((File)new File(dir, name));
        return this.originalFilePattern.matcher(name).matches() ? StringsKt.equals((String)this.eventFileOriginalStagingBaseName, (String)baseName, (boolean)true) : false;
    }

    @NotNull
    public final String getEventFileOriginalStagingBaseName() {
        return this.eventFileOriginalStagingBaseName;
    }

    @NotNull
    public final Pattern getOriginalFilePattern() {
        return this.originalFilePattern;
    }

    public StagingFilenameFilter(@NotNull String eventFileOriginalStagingBaseName, @NotNull Pattern originalFilePattern) {
        Intrinsics.checkNotNullParameter((Object)eventFileOriginalStagingBaseName, (String)"eventFileOriginalStagingBaseName");
        Intrinsics.checkNotNullParameter((Object)originalFilePattern, (String)"originalFilePattern");
        this.eventFileOriginalStagingBaseName = eventFileOriginalStagingBaseName;
        this.originalFilePattern = originalFilePattern;
    }
}

