/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.coinbub.daemon.normalization.Normalized;

public class NotificationListener
extends Observable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationListener.class);
    private int port;
    private Thread listener;
    private Transformer transformer;
    private final SocketListener socketListener;
    private final Thread socketListenerThread;
    private final LinkedBlockingQueue<String> data = new LinkedBlockingQueue();

    public NotificationListener() throws IOException {
        this(0);
    }

    public NotificationListener(int port) throws IOException {
        this(new ServerSocket(port));
    }

    public NotificationListener(ServerSocket server) throws IOException {
        this.socketListener = new SocketListener(server);
        this.socketListenerThread = new Thread(this.socketListener);
        server.setReuseAddress(true);
        this.port = server.getLocalPort();
    }

    @Override
    public void run() {
        this.socketListenerThread.start();
        do {
            try {
                String line = this.data.take();
                this.setChanged();
                this.notifyObservers(this.transform(line));
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        } while (!Thread.currentThread().isInterrupted());
        LOGGER.info("Listener " + Thread.currentThread().getName() + " exited");
    }

    public int getPort() {
        return this.socketListener.getPort();
    }

    @Override
    public synchronized void addObserver(Observer o) {
        this.start();
        super.addObserver(o);
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void start() {
        if (this.listener == null) {
            this.listener = new Thread((Runnable)this, "notification-listener");
            this.listener.start();
        }
    }

    public void stop() throws IOException {
        this.socketListener.stop();
        this.interrupt();
    }

    public void interrupt() throws IOException {
        if (this.listener != null) {
            this.listener.interrupt();
        }
    }

    protected Object transform(String line) {
        if (this.transformer != null) {
            return this.transformer.transform(line);
        }
        return line;
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public class SocketListener
    implements Runnable {
        private final ServerSocket server;

        public SocketListener(ServerSocket server) {
            this.server = server;
        }

        @Override
        public void run() {
            LOGGER.info("Listening for notifications on port {}", (Object)this.getPort());
            while (!Thread.currentThread().isInterrupted() && !this.server.isClosed()) {
                try {
                    Socket connection = this.server.accept();
                    Throwable throwable = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                        Throwable throwable2 = null;
                        try {
                            String line = reader.readLine();
                            if (line == null) continue;
                            NotificationListener.this.data.add(line);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (connection == null) continue;
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        connection.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }
            LOGGER.info("Listener " + Thread.currentThread().getName() + " exited");
        }

        public int getPort() {
            return this.server.getLocalPort();
        }

        public void stop() throws IOException {
            this.server.close();
        }
    }

    public static class BlockTransformer
    implements Transformer {
        private final Normalized normalized;

        public BlockTransformer(Normalized normalized) {
            this.normalized = normalized;
        }

        @Override
        public Object transform(String line) {
            return this.normalized.getblock(line);
        }
    }

    public static class TransactionTransformer
    implements Transformer {
        private final Normalized normalized;

        public TransactionTransformer(Normalized normalized) {
            this.normalized = normalized;
        }

        @Override
        public Object transform(String line) {
            return this.normalized.gettransaction(line);
        }
    }

    public static interface Transformer {
        public Object transform(String var1);
    }
}

