/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon;

import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.coinbub.daemon.NotificationListener;
import tech.coinbub.daemon.normalization.Normalized;
import tech.coinbub.daemon.proxy.ProxyUtil;

public class DaemonRunner<T> {
    private static final char[] USERNAME_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] PASSWORD_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_!*^$@.,/\\".toCharArray();
    private static final Random RANDOM = new SecureRandom();
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonRunner.class);
    private final String id;
    private Listener listener = new NoopListener();
    private JsonRpcClient client;
    private T iface;
    private Normalized<T> normalized;
    private Process process;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Please specify an executable path");
        }
        String path = args[0];
        if (args.length < 2) {
            throw new IllegalArgumentException("Please specify a daemon interface");
        }
        Class<?> clientClass = Class.forName(args[1]);
        if (args.length < 3) {
            throw new IllegalArgumentException("Please specify a normalized daemon interface");
        }
        Class<?> normalizedClass = Class.forName(args[2]);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(args));
        cmd.remove(0);
        cmd.remove(0);
        cmd.remove(0);
        new DaemonRunner(UUID.randomUUID().toString()).start(path, cmd, clientClass, normalizedClass);
    }

    public DaemonRunner() {
        this(UUID.randomUUID().toString());
    }

    public DaemonRunner(String id) {
        this.id = id;
    }

    public void start(String path, List<String> cmd, Class<T> clientClass, Class<? extends Normalized> normalizedClass) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            throw new RuntimeException("Windows not supported");
        }
        String user = DaemonRunner.randomString(16, USERNAME_CHARS);
        String password = DaemonRunner.randomString(64, PASSWORD_CHARS);
        int port = DaemonRunner.findFreePort();
        String[] ignored = new String[]{"rpcuser", "rpcpassword", "notify"};
        ArrayList<String> l = new ArrayList<String>();
        l.add(path);
        block0: for (String part : cmd) {
            for (String ignore : ignored) {
                if (!part.toLowerCase().contains(ignore)) continue;
                LOGGER.warn(part + " ignored");
                continue block0;
            }
            l.add(part);
        }
        l.add("-rpcuser=" + user);
        l.add("-rpcpassword=" + password);
        l.add("-rpcport=" + port);
        this.listener.prepare(l);
        ProcessBuilder builder = new ProcessBuilder(l).inheritIO();
        LOGGER.info("Daemon startup command: " + String.join((CharSequence)" ", builder.command()));
        this.process = builder.start();
        URL url = new URL("http://localhost:" + port);
        LOGGER.info("Using URL {}", (Object)url.toString());
        this.client = new JsonRpcHttpClient(url, DaemonRunner.headers(user, password));
        this.iface = ProxyUtil.createClientProxy(this.getClass().getClassLoader(), clientClass, (IJsonRpcClient)this.client);
        this.normalized = normalizedClass.getConstructor(clientClass).newInstance(this.iface);
        this.listener.build(this.normalized);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public T getRawInterface() {
        return this.iface;
    }

    public Normalized<T> getNormalizedInterface() {
        return this.normalized;
    }

    private static Map<String, String> headers(String username, String password) {
        String cred = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + cred);
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private static int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private static String convertStream(InputStream is) {
        Scanner s = new Scanner(is, "utf8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static String randomString(int len, char[] chars) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(chars[RANDOM.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    public static class NoopListener
    implements Listener {
        @Override
        public void prepare(List<String> cmd) throws IOException {
            LOGGER.info("No listener factory provided");
        }

        @Override
        public void build(Normalized normalized) throws IOException {
        }

        @Override
        public void onBlock(Observer observer) {
        }

        @Override
        public void onTransaction(Observer observer) {
        }
    }

    public static class StandardBitcoinListener
    implements Listener {
        private ServerSocket blockSocket;
        private ServerSocket walletSocket;
        private NotificationListener blockListener;
        private NotificationListener walletListener;

        @Override
        public void prepare(List<String> cmd) throws IOException {
            this.blockSocket = new ServerSocket(0);
            this.walletSocket = new ServerSocket(0);
            this.blockListener = new NotificationListener(this.blockSocket);
            this.walletListener = new NotificationListener(this.walletSocket);
            cmd.add("-blocknotify=\"echo '%s' | nc 127.0.0.1 " + this.blockSocket.getLocalPort() + "\"");
            cmd.add("-walletnotify=\"echo '%s' | nc 127.0.0.1 " + this.walletSocket.getLocalPort() + "\"");
        }

        @Override
        public void build(Normalized normalized) throws IOException {
            this.blockListener.setTransformer(new NotificationListener.BlockTransformer(normalized));
            this.walletListener.setTransformer(new NotificationListener.TransactionTransformer(normalized));
        }

        @Override
        public void onBlock(Observer observer) {
            this.blockListener.addObserver(observer);
        }

        @Override
        public void onTransaction(Observer observer) {
            this.walletListener.addObserver(observer);
        }
    }

    public static interface Listener {
        public void prepare(List<String> var1) throws IOException;

        public void build(Normalized var1) throws IOException;

        public void onBlock(Observer var1);

        public void onTransaction(Observer var1);
    }
}

