/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon.testutils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.beans.PropertyUtil;

public class BeanPropertyMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final String matchingPropertyName;
    private final Matcher<?> valueMatcher;

    @Factory
    public static <T> BeanPropertyMatcher<T> property(String propertyName, Matcher<?> value) {
        return new BeanPropertyMatcher<T>(propertyName, value);
    }

    public BeanPropertyMatcher(String propertyName, Matcher<?> valueMatcher) {
        this.matchingPropertyName = propertyName;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(T bean, Description mismatchDescription) {
        try {
            return this.matchesSafely(bean, this.matchingPropertyName, mismatchDescription);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean matchesSafely(Object bean, String propertyName, Description mismatchDescription) throws Exception {
        Object parentObject = bean;
        if (this.isComposedProperty(propertyName)) {
            String memberObjectProperty = this.getMemberObjectProperty(propertyName);
            Object memberObject = this.getPropertyValue(parentObject, memberObjectProperty);
            String nextProperty = this.getNextProperty(propertyName);
            return this.matchesSafely(memberObject, nextProperty, mismatchDescription);
        }
        return this.matchProperty(bean, propertyName, mismatchDescription);
    }

    private String getNextProperty(String composedPropertyName) {
        return composedPropertyName.substring(composedPropertyName.indexOf(".") + 1);
    }

    private Object getPropertyValue(Object parentObject, String memberObjectProperty) throws Exception {
        PropertyDescriptor property = PropertyUtil.getPropertyDescriptor((String)memberObjectProperty, (Object)parentObject);
        Method readMethod = property.getReadMethod();
        return readMethod.invoke(parentObject, PropertyUtil.NO_ARGUMENTS);
    }

    private boolean isComposedProperty(String propertyName) {
        return propertyName.contains(".");
    }

    private String getMemberObjectProperty(String composedPropertyName) {
        return composedPropertyName.substring(0, composedPropertyName.indexOf("."));
    }

    private boolean matchProperty(Object bean, String propertyName, Description mismatchDescription) throws Exception {
        try {
            Field field = bean.getClass().getDeclaredField(propertyName);
            Object propertyValue = field.get(bean);
            boolean valueMatches = this.valueMatcher.matches(propertyValue);
            if (!valueMatches) {
                this.appendSeparatorTo(mismatchDescription);
                mismatchDescription.appendText("property \"" + this.matchingPropertyName + "\" ");
                this.valueMatcher.describeMismatch(propertyValue, mismatchDescription);
            }
            return valueMatches;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    private void appendSeparatorTo(Description description) {
        if (description.toString().length() > 0) {
            description.appendText(", ");
        }
    }

    String getPropertyName() {
        return this.matchingPropertyName;
    }

    public void describeTo(Description description) {
        this.appendSeparatorTo(description);
        description.appendText("property ");
        description.appendValue((Object)this.matchingPropertyName);
        description.appendText(" = ");
        description.appendDescriptionOf(this.valueMatcher);
        description.appendText(" ");
    }
}

