/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon.testutils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import tech.coinbub.daemon.testutils.BeanPropertyMatcher;

public class BeanMatcher<T>
extends BaseMatcher<T> {
    private final List<BeanPropertyMatcher<?>> propertyMatchers;
    private final Description expectedDescription = new StringDescription();
    private final Description mismatchDescription = new StringDescription();
    private final boolean only;

    @Factory
    public static <T> BeanMatcher<T> has(BeanPropertyMatcher<?> ... propertyMatchers) {
        return new BeanMatcher<T>(propertyMatchers);
    }

    @Factory
    public static <T> BeanMatcher<T> hasOnly(BeanPropertyMatcher<?> ... propertyMatchers) {
        return new BeanMatcher<T>(true, propertyMatchers);
    }

    public BeanMatcher(BeanPropertyMatcher<?> ... propertyMatchers) {
        this(false, propertyMatchers);
    }

    public BeanMatcher(boolean only, BeanPropertyMatcher<?> ... propertyMatchers) {
        this.propertyMatchers = Arrays.asList(propertyMatchers);
        this.only = only;
    }

    public boolean matches(Object item) {
        ArrayList matchers = new ArrayList(this.propertyMatchers);
        if (this.only) {
            Set knownFields = this.propertyMatchers.stream().map(m -> m.getPropertyName()).collect(Collectors.toSet());
            for (Field field : item.getClass().getDeclaredFields()) {
                if (knownFields.contains(field.getName()) || field.isSynthetic()) continue;
                matchers.add(BeanPropertyMatcher.property(field.getName(), Matchers.is((Matcher)Matchers.nullValue())));
            }
        }
        boolean matches = true;
        for (BeanPropertyMatcher beanPropertyMatcher : matchers) {
            if (beanPropertyMatcher.matches(item)) continue;
            matches = false;
            this.appendDescriptions(item, (Matcher<?>)beanPropertyMatcher);
        }
        return matches;
    }

    public void describeTo(Description description) {
        description.appendText(this.expectedDescription.toString());
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText(this.mismatchDescription.toString());
    }

    private void appendDescriptions(Object item, Matcher<?> matcher) {
        matcher.describeTo(this.expectedDescription);
        matcher.describeMismatch(item, this.mismatchDescription);
        this.expectedDescription.appendText(" \n");
        this.mismatchDescription.appendText(" \n");
    }
}

