/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon.testutils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.DockerClientBuilder;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import com.googlecode.jsonrpc4j.ProxyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.coinbub.daemon.testutils.Util;

public class Dockerized
implements BeforeAllCallback,
ParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dockerized.class);
    private static final int RPC_PORT = 10001;
    private static DockerClient docker;
    private static String containerId;
    private static int hostPort;
    private static JsonRpcClient rpcClient;
    private static Class<?> clientClass;
    private static Object client;
    private static boolean persistent;

    public void beforeAll(ExtensionContext context) throws Exception {
        if (client != null) {
            return;
        }
        Properties props = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("/docker.properties");){
            if (is == null) {
                throw new RuntimeException("Unable to load docker properties. Make sure `docker.properties` exists in src/test/resources");
            }
            props.load(is);
        }
        String image = props.getProperty("image");
        String portStr = props.getProperty("port");
        int portNum = Integer.parseInt(portStr);
        String rpcuser = props.getProperty("rpcuser", "user");
        String rpcpass = props.getProperty("rpcpass", "pass");
        String name = props.getProperty("name");
        String[] cmd = props.getProperty("cmd").split(" ");
        String confPath = props.getProperty("conf");
        clientClass = Class.forName(props.getProperty("class"));
        persistent = Boolean.parseBoolean(props.getProperty("persistent", "false"));
        docker = DockerClientBuilder.getInstance().build();
        containerId = docker.createContainerCmd(image).withStdInOnce(Boolean.valueOf(false)).withStdinOpen(Boolean.valueOf(false)).withPortSpecs(new String[]{portStr}).withExposedPorts(new ExposedPort[]{ExposedPort.tcp((int)portNum)}).withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindIp((String)"0.0.0.0"), ExposedPort.tcp((int)portNum))}).withName(name).withCmd(cmd).exec().getId();
        LOGGER.info("Started container {}", (Object)containerId);
        try (InputStream stream = this.getClass().getResourceAsStream("/conf.tar.gz");){
            if (stream == null) {
                throw new IOException("Could not retrieve conf.tar.gz");
            }
            docker.copyArchiveToContainerCmd(containerId).withTarInputStream(stream).withRemotePath(confPath).exec();
            docker.startContainerCmd(containerId).exec();
            Map bindings = docker.inspectContainerCmd(containerId).exec().getNetworkSettings().getPorts().getBindings();
            for (Map.Entry port : bindings.entrySet()) {
                if (((ExposedPort)port.getKey()).getPort() != 10001) continue;
                if (port.getValue() == null || ((Ports.Binding[])port.getValue()).length != 1) {
                    throw new RuntimeException("Found " + ((Ports.Binding[])port.getValue()).length + " bound ports. Expected 1");
                }
                hostPort = Integer.parseInt(((Ports.Binding[])port.getValue())[0].getHostPortSpec());
            }
            if (hostPort < 0) {
                throw new RuntimeException("RPC port 10001 not bound to host");
            }
            LOGGER.info("RPC port 10001 bound to " + hostPort);
        }
        rpcClient = new JsonRpcHttpClient(new URL("http://localhost:" + hostPort), Util.headers(rpcuser, rpcpass));
        client = ProxyUtil.createClientProxy((ClassLoader)this.getClass().getClassLoader(), clientClass, (IJsonRpcClient)((IJsonRpcClient)rpcClient));
        Thread.sleep(2000L);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!persistent) {
                docker.stopContainerCmd(containerId).exec();
                docker.removeContainerCmd(containerId).exec();
                LOGGER.info("Stopped and removed container {}", (Object)containerId);
            } else {
                LOGGER.info("Left container {} alive", (Object)containerId);
            }
        }));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(clientClass);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return client;
    }

    static {
        hostPort = -1;
        persistent = false;
    }
}

