/*
 * Decompiled with CFR 0.152.
 */
package tech.coinbub.daemon;

import java.math.BigDecimal;
import java.util.ArrayList;
import tech.coinbub.daemon.Bitcoin;
import tech.coinbub.daemon.bitcoin.Transaction;
import tech.coinbub.daemon.bitcoin.TransactionDetail;
import tech.coinbub.daemon.normalization.Normalized;
import tech.coinbub.daemon.normalization.model.Block;

public class NormalizedBitcoin
implements Normalized<Bitcoin> {
    private final Bitcoin client;

    public NormalizedBitcoin(Bitcoin client) {
        if (client == null) {
            throw new IllegalArgumentException("Client must not be null");
        }
        this.client = client;
    }

    public String getblockhash(Long height) {
        return this.client.getblockhash(height);
    }

    public Block getblock(String hash) {
        tech.coinbub.daemon.bitcoin.Block block = this.client.getblock(hash);
        Block result = new Block();
        result.hash = block.hash;
        result.confirmations = block.confirmations;
        result.size = block.size;
        result.height = block.height;
        result.time = block.time;
        result.previousblockhash = block.previousblockhash;
        if (!block.tx.isEmpty()) {
            result.tx = new ArrayList();
        }
        for (Transaction tx : block.tx) {
            result.tx.add(tx.txid);
        }
        return result;
    }

    public tech.coinbub.daemon.normalization.model.Transaction gettransaction(String txid) {
        return this.normalizeTransaction(this.client.gettransaction(txid));
    }

    public String getnewaddress() {
        return this.client.getnewaddress();
    }

    public String sendtoaddress(String address, BigDecimal amount) {
        return this.client.sendtoaddress(address, amount);
    }

    public String sendtoaddress(String address, BigDecimal amount, String comment_from) {
        return this.client.sendtoaddress(address, amount, comment_from);
    }

    public String sendtoaddress(String address, BigDecimal amount, String comment_from, String comment_to) {
        return this.client.sendtoaddress(address, amount, comment_from, comment_to);
    }

    private tech.coinbub.daemon.normalization.model.Transaction normalizeTransaction(Transaction tx) {
        tech.coinbub.daemon.normalization.model.Transaction result = new tech.coinbub.daemon.normalization.model.Transaction();
        result.id = tx.txid;
        result.amount = tx.amount;
        result.fee = tx.fee;
        result.time = tx.time;
        result.size = tx.size;
        result.confirmations = tx.confirmations;
        result.blockhash = tx.blockhash;
        result.comment_from = tx.comment;
        result.comment_to = tx.to;
        if (!tx.details.isEmpty()) {
            result.details = new ArrayList();
        }
        for (TransactionDetail rawDetail : tx.details) {
            tech.coinbub.daemon.normalization.model.TransactionDetail detail = new tech.coinbub.daemon.normalization.model.TransactionDetail();
            detail.address = rawDetail.address;
            detail.amount = rawDetail.amount;
            detail.fee = rawDetail.fee;
            result.details.add(detail);
        }
        return result;
    }
}

