/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.codingless.core.plugs.mybaties3.annotation.MyColumn;
import tech.codingless.core.plugs.mybaties3.annotation.MyTable;
import tech.codingless.core.plugs.mybaties3.annotation.OrderTypeEnum;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.helper.MyTableColumnParser;
import tech.codingless.core.plugs.mybaties3.helper.PrimaryKey;
import tech.codingless.core.plugs.mybaties3.util.MybatiesAssertUtil;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class CommonSQLHelper {
    private static final String BLOCK = " ";
    private static final String SPLIT_AND = " and ";
    private static final String WHERE = "  where  ";
    private static String SPLIT_WORDS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static Map<String, Map<String, String>> CACHE = new HashMap<String, Map<String, String>>();
    private static ConcurrentHashMap<Class<?>, String> TABLE_NAME_CACHE = new ConcurrentHashMap(100);
    private static PrimaryKey ID = null;

    public static String getTableName(Object entity) {
        return CommonSQLHelper.getTableName(entity.getClass());
    }

    public static String getTableName(Class entity) {
        if (TABLE_NAME_CACHE.containsKey(entity)) {
            return TABLE_NAME_CACHE.get(entity);
        }
        String tableName = CommonSQLHelper.change2dbFormat(entity.getSimpleName());
        try {
            MyTable myTable = entity.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getClass().getAnnotation(MyTable.class);
            tableName = MybatiesStringUtil.isEmpty(myTable.prefix()) ? "uni" : myTable.prefix().trim() + "_" + CommonSQLHelper.change2dbFormat(entity.getSimpleName());
            tableName = tableName.replace("_D_O", "").toUpperCase();
            TABLE_NAME_CACHE.put(entity, tableName);
            return tableName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getInsertSQL(Object entity) {
        Map<String, String> columns = CommonSQLHelper.getColumnAndProperties(entity.getClass());
        if (columns == null) {
            throw new RuntimeException(entity.getClass() + " \u83b7\u53d6\u4e0d\u5230\u5b57\u6bb5\u5173\u7cfb!");
        }
        StringBuffer columnSB = new StringBuffer();
        StringBuffer propertySB = new StringBuffer();
        for (String column : columns.keySet()) {
            columnSB.append(column).append(",");
            if ("gmtCreate".equals(columns.get(column)) || "gmtWrite".equals(columns.get(column))) {
                propertySB.append("UNIX_TIMESTAMP(),");
                continue;
            }
            propertySB.append("#{").append(columns.get(column)).append("},");
        }
        if (columnSB.length() > 0) {
            columnSB.deleteCharAt(columnSB.length() - 1);
            propertySB.deleteCharAt(propertySB.length() - 1);
        }
        return String.format("INSERT INTO %s(%s)values(%s)", CommonSQLHelper.getTableName(entity), columnSB.toString(), propertySB.toString());
    }

    public static String getInsertSQLBatch(Object entity) {
        Map<String, String> columns = CommonSQLHelper.getColumnAndProperties(entity.getClass());
        if (columns == null) {
            throw new RuntimeException(entity.getClass() + " \u83b7\u53d6\u4e0d\u5230\u5b57\u6bb5\u5173\u7cfb!");
        }
        StringBuffer columnSB = new StringBuffer();
        StringBuffer propertySB = new StringBuffer();
        for (String column : columns.keySet()) {
            columnSB.append(column).append(",");
            if ("gmtCreate".equals(columns.get(column)) || "gmtWrite".equals(columns.get(column))) {
                propertySB.append("UNIX_TIMESTAMP(),");
                continue;
            }
            propertySB.append("#{").append(columns.get(column)).append("},");
        }
        if (columnSB.length() > 0) {
            columnSB.deleteCharAt(columnSB.length() - 1);
            propertySB.deleteCharAt(propertySB.length() - 1);
        }
        String forEachStart = "<foreach collection=\"list\" index=\"index\" item=\"ele\"  separator=\",\">";
        String forEachEnd = "</foreach>";
        return String.format("INSERT INTO %s(%s)values %s(%s) %s", CommonSQLHelper.getTableName(entity), columnSB.toString(), forEachStart, propertySB.toString(), forEachEnd);
    }

    private static Map<String, String> getColumnAndProperties(Class clazz) {
        if (clazz.getAnnotation(MyTable.class) == null) {
            throw new RuntimeException(clazz.getName() + " \u4e0d\u662f\u4e00\u4e2a\u5b9e\u4f53\u7c7b!");
        }
        String tableName = CommonSQLHelper.getTableName(clazz);
        if (CACHE.containsKey(tableName)) {
            return CACHE.get(tableName);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Object pName = new String();
            if (methodName.startsWith("get")) {
                pName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                pName = methodName.substring(2);
            }
            pName = ((String)pName).substring(0, 1).toLowerCase() + ((String)pName).substring(1);
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField((String)pName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null) {
                    columnName = MybatiesStringUtil.isNotEmpty(myColumn.name()) ? myColumn.name() : columnName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat((String)pName);
            }
            map.put(columnName, (String)pName);
        }
        CACHE.put(tableName, map);
        return map;
    }

    public static String change2dbFormat(String string) {
        StringBuffer sb = new StringBuffer(string);
        int len = sb.length();
        for (int i = 1; i < len; ++i) {
            if (!SPLIT_WORDS.contains("" + sb.charAt(i))) continue;
            sb.insert(i, "_");
            ++i;
            ++len;
        }
        return sb.toString();
    }

    public static String getDeleteSQL(Class<?> clazz) {
        PrimaryKey primaryKey = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(primaryKey, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("delete from %s where %s = #{entityId}", CommonSQLHelper.getTableName(clazz), primaryKey.getColumn());
    }

    public static String getDeleteWithCompanyIdSQL(Class<?> clazz) {
        PrimaryKey primaryKey = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(primaryKey, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("delete from %s where %s = #{entityId} and company_id=#{company_id}", CommonSQLHelper.getTableName(clazz), primaryKey.getColumn());
    }

    private static PrimaryKey getPrimaryKey(Class<?> clazz) {
        if (ID == null) {
            ID = new PrimaryKey();
            ID.setColumn("id");
            ID.setAttrName("id");
        }
        return ID;
    }

    public static String getUpdateSQL(Class<?> clazz) {
        return CommonSQLHelper.gentUpdateSQLWithCompanyId(clazz, false);
    }

    public static String getUpdateSQLWithCompanyId(Class<?> clazz) {
        return CommonSQLHelper.gentUpdateSQLWithCompanyId(clazz, true);
    }

    private static String gentUpdateSQLWithCompanyId(Class<?> clazz, boolean companyIdCondition) {
        Map<String, String> columns = CommonSQLHelper.getColumnAndProperties(clazz);
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        MybatiesAssertUtil.assertNotNull(columns, clazz + " \u83b7\u53d6\u4e0d\u5230\u5b57\u6bb5\u5173\u7cfb!");
        StringBuffer setContent = new StringBuffer();
        for (String column : columns.keySet()) {
            String attrName;
            if (column.equals(key.getColumn()) || "gmtCreate".equals(attrName = columns.get(column)) || "createUid".equals(attrName) || "ownerId".equals(attrName)) continue;
            if ("gmtWrite".equals(attrName)) {
                setContent.append(column).append("=").append("UNIX_TIMESTAMP(),");
                continue;
            }
            setContent.append(column).append("=").append("#{").append(attrName).append("},");
        }
        if (setContent.length() > 0) {
            setContent.deleteCharAt(setContent.length() - 1);
        }
        if (companyIdCondition) {
            return String.format("update %s set %s where %s=#{%s}  and company_id = #{companyId}", CommonSQLHelper.getTableName(clazz), setContent.toString(), key.getColumn(), key.getAttrName());
        }
        return String.format("update %s set %s where %s=#{%s} ", CommonSQLHelper.getTableName(clazz), setContent.toString(), key.getColumn(), key.getAttrName());
    }

    public static String getGetSQL(Class<?> clazz) {
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        if (key == null) {
            throw new RuntimeException(clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        }
        return String.format("select * from %s where %s = #{%s} and not del and env=#{env}", CommonSQLHelper.getTableName(clazz), key.getColumn(), key.getAttrName());
    }

    public static String getGetSQLByCompanyId(Class<?> clazz) {
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("select * from %s where %s = #{%s}  and  company_id =#{companyId} and not del", CommonSQLHelper.getTableName(clazz), key.getColumn(), key.getAttrName());
    }

    public static String getListSQL(Class<?> clazz) {
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("select * from %s order by  gmt_create asc", CommonSQLHelper.getTableName(clazz));
    }

    public static String getListByCompanySQL(Class<?> clazz) {
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("select * from %s  where  company_id = #{companyId} and not del order by  gmt_create asc", CommonSQLHelper.getTableName(clazz));
    }

    public static ExecuteSql genSelectSqlSkipNullProperties(String companyId, BaseDO entity, String orderColumn, OrderTypeEnum orderType, Integer limit, Integer offset) throws Exception {
        Class<?> clazz = entity.getClass();
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        ExecuteSql sql = new ExecuteSql();
        sql.setParam(new ArrayList<Object>());
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select *  from  ").append(CommonSQLHelper.getTableName(clazz));
        boolean needWhereKeyword = true;
        if (MybatiesStringUtil.isNotEmpty(companyId)) {
            selectSql.append(WHERE);
            needWhereKeyword = false;
            selectSql.append(BLOCK).append("company_id=").append("#{companyId} and not del");
            sql.getParam().add(companyId);
        }
        List<MyTableColumnParser.ColumnProp> columns = MyTableColumnParser.parseSkipNull(clazz, entity);
        for (MyTableColumnParser.ColumnProp column : columns) {
            if (needWhereKeyword) {
                selectSql.append(WHERE);
                needWhereKeyword = false;
            } else {
                selectSql.append(SPLIT_AND);
            }
            selectSql.append(column.getColumn()).append("=#{obj." + column.getProp() + "}");
            sql.getParam().add(column.getVal());
        }
        if (MybatiesStringUtil.isNotEmpty(orderColumn) && orderType != null) {
            selectSql.append(" order by ").append(orderColumn).append(BLOCK).append(orderType.getCode());
        }
        selectSql.append(BLOCK).append(" limit  #{limit} offset #{offset}");
        sql.getParam().add(limit);
        sql.getParam().add(offset);
        sql.setSql(selectSql.toString());
        return sql;
    }

    public static ExecuteSql genCountSqlSkipNullProperties(String companyId, BaseDO entity) throws Exception {
        Class<?> clazz = entity.getClass();
        PrimaryKey key = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(key, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        ExecuteSql sql = new ExecuteSql();
        sql.setParam(new ArrayList<Object>());
        StringBuilder selectSql = new StringBuilder();
        boolean needWhereKeyword = true;
        selectSql.append("select count(1) as total_Count  from  ").append(CommonSQLHelper.getTableName(clazz));
        if (MybatiesStringUtil.isNotEmpty(companyId)) {
            selectSql.append(WHERE);
            needWhereKeyword = false;
            selectSql.append(BLOCK).append("company_id=").append("#{companyId} and not del");
            sql.getParam().add(companyId);
        }
        List<MyTableColumnParser.ColumnProp> columns = MyTableColumnParser.parseSkipNull(clazz, entity);
        for (MyTableColumnParser.ColumnProp column : columns) {
            if (needWhereKeyword) {
                selectSql.append(WHERE);
                needWhereKeyword = false;
            } else {
                selectSql.append(SPLIT_AND);
            }
            selectSql.append(column.getColumn()).append("=#{obj." + column.getProp() + "}");
            sql.getParam().add(column.getVal());
        }
        sql.setSql(selectSql.toString());
        return sql;
    }

    public static String getDeleteLogicalWithCompanyIdSQL(Class<?> clazz) {
        PrimaryKey primaryKey = CommonSQLHelper.getPrimaryKey(clazz);
        MybatiesAssertUtil.assertNotNull(primaryKey, clazz + " \u7f3a\u5c11\u4e3b\u952e!");
        return String.format("update %s set del=true where %s = #{entityId} and company_id=#{company_id}", CommonSQLHelper.getTableName(clazz), primaryKey.getColumn());
    }

    public static class ExecuteSql {
        private String sql;
        private List<Object> param;

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setParam(List<Object> param) {
            this.param = param;
        }

        public String getSql() {
            return this.sql;
        }

        public List<Object> getParam() {
            return this.param;
        }
    }
}

