/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.codingless.core.plugs.mybaties3.TableAutoCreateService;
import tech.codingless.core.plugs.mybaties3.annotation.MyColumn;
import tech.codingless.core.plugs.mybaties3.annotation.MyComment;
import tech.codingless.core.plugs.mybaties3.annotation.MyTable;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.enums.DbNameConstant;
import tech.codingless.core.plugs.mybaties3.strategy.DataSourceCreator;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

@Service
public class TableAutoCreateServiceMysqlImpl
implements TableAutoCreateService {
    private static final Logger LOG = LoggerFactory.getLogger(TableAutoCreateServiceMysqlImpl.class);
    private static String TABLE_NAME = "uni_";
    private static String SPLIT_WORDS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String url = "";
    private String user = "";
    private String pwd = "";
    private String dataSourceUrl = null;
    private String dbName = "";
    private static ConcurrentHashMap<String, Boolean> EXIST_TABLE_NAME = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> EXIST_COLUMN_NAME = new ConcurrentHashMap();
    @Autowired(required=false)
    DataSourceCreator dataSourceFactory;
    private List<BaseDO> doList;
    Connection conn = null;

    @Override
    public void setPassword(String password) {
        this.pwd = password;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        DbNameConstant.DB_NAME = this.dbName = url.split("/")[3].split("[\\?]")[0];
    }

    @Override
    public void setUsername(String username) {
        this.user = username;
    }

    @Override
    public boolean create() {
        if (CollectionUtils.isEmpty(this.doList)) {
            LOG.info("\u6ca1\u6709\u53d1\u73b0\u5b9e\u4f53\u7c7b\uff0c\u4e0d\u7528\u521b\u5efa\u4efb\u4f55\u8868\u683c!");
            return false;
        }
        this.getConn();
        this.query(String.format("SELECT table_name FROM information_schema.TABLES WHERE table_schema = '%s'", this.dbName)).forEach(row -> EXIST_TABLE_NAME.put(((String)row.get("table_name")).toLowerCase(), true));
        this.query(String.format("select table_name,column_name  from information_schema.columns where table_schema= '%s'", this.dbName)).forEach(row -> EXIST_COLUMN_NAME.put(((String)row.get("table_name")).toLowerCase() + "/" + ((String)row.get("column_name")).toLowerCase(), true));
        this.doList = this.doList.stream().filter(item -> item.getClass().getAnnotation(MyTable.class) != null).collect(Collectors.toList());
        this.doList.forEach(item -> {
            try {
                LOG.info("\u89e3\u6790\u5b9e\u4f53\u7c7b:" + item.getClass().getName());
                this.createTable(item);
                this.parserObject(item);
            }
            catch (Exception e) {
                LOG.error("\u89e3\u6790\u5b9e\u4f53\u7c7b", (Throwable)e);
            }
        });
        return true;
    }

    private void createTable(Object obj) {
        String tableName = this.getTableName(obj);
        if (EXIST_TABLE_NAME.containsKey(tableName)) {
            return;
        }
        String ddl = String.format("CREATE TABLE %s (id VARCHAR(64) PRIMARY KEY)", tableName);
        this.executeDDL(ddl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDL(String ddl) {
        Connection conn = this.getConn();
        try {
            Statement stmt = conn.createStatement();
            LOG.info(ddl);
            stmt.executeUpdate(ddl);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("CREATE_DDL_FAIL", (Throwable)e);
        }
    }

    private Connection getConn() {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            if (this.dataSourceFactory != null) {
                DataSource dataSource = this.dataSourceFactory.make();
                this.conn = dataSource.getConnection();
                this.dataSourceUrl = this.conn.getMetaData().getURL();
                this.setUrl(this.dataSourceUrl);
                return this.conn;
            }
            this.conn = DriverManager.getConnection(this.url, this.user, this.pwd);
            return this.conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> query(String sql) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Connection conn = this.getConn();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                list.add(map);
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = rsmd.getColumnName(i + 1).toLowerCase();
                    String value = rs.getString(i + 1);
                    map.put(columnName, value);
                }
            }
        }
        catch (Exception e) {
            LOG.error("query error", (Throwable)e);
        }
        return list;
    }

    private String getTableName(Object obj) {
        return TableAutoCreateServiceMysqlImpl.getTableName(obj.getClass());
    }

    public static String getTableName(Class<?> clazz) {
        MyTable myTable = clazz.getAnnotation(MyTable.class);
        String tableName = MybatiesStringUtil.isEmpty(myTable.prefix()) ? TABLE_NAME : myTable.prefix().trim() + "_" + TableAutoCreateServiceMysqlImpl.change2dbFormat(clazz.getSimpleName());
        tableName = tableName.replace("_D_O", "").toLowerCase();
        return tableName;
    }

    private void parserObject(Object obj) {
        Class<?> parentClazz = obj.getClass().getSuperclass();
        if (!parentClazz.equals(Object.class) && !parentClazz.equals(BaseDO.class)) {
            this.createColumn(obj, parentClazz.getDeclaredFields());
        }
        this.createColumn(obj, BaseDO.class.getDeclaredFields());
        this.createColumn(obj, obj.getClass().getDeclaredFields());
    }

    private void createColumn(Object obj, Field[] fields) {
        if (fields == null) {
            return;
        }
        String tableName = this.getTableName(obj);
        StringBuilder ddls = new StringBuilder();
        boolean needCreateColumn = false;
        for (Field field : fields) {
            String columnName = TableAutoCreateServiceMysqlImpl.change2dbFormat(field.getName()).toLowerCase();
            if (this.columnExist(tableName, columnName)) continue;
            Class<?> typeClazz = field.getType();
            MyColumn myColumn = field.getAnnotation(MyColumn.class);
            MyComment myComment = field.getAnnotation(MyComment.class);
            String typeDef = this.detectedColumnTypeByClassType(typeClazz, columnName);
            if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.type())) {
                typeDef = myColumn.type();
            }
            String defaultValue = myColumn != null ? myColumn.defaultValue() : "";
            Object commentSql = "";
            if (myComment != null && MybatiesStringUtil.isNotEmpty(myComment.value())) {
                commentSql = "  COMMENT '" + myComment.value().replaceAll("'", "") + "'";
            }
            Object autoIncrementSql = "";
            if (myColumn != null && myColumn.autoIncrement()) {
                autoIncrementSql = "not null auto_increment ";
            }
            if (myColumn != null) {
                if (myColumn.autoIncrement()) {
                    autoIncrementSql = "not null auto_increment ";
                }
                if (myColumn.autoIncrement() || myColumn.createIndex()) {
                    autoIncrementSql = (String)autoIncrementSql + ", add  key(" + columnName + ")";
                }
            }
            String ddl = String.format("ALTER table %s ADD COLUMN %s %s %s %s %s", tableName, columnName, typeDef, MybatiesStringUtil.isNotEmpty(defaultValue) ? "default " + defaultValue : "", commentSql, autoIncrementSql);
            LOG.info(ddl);
            ddls.append(ddl).append(";");
            needCreateColumn = true;
        }
        if (needCreateColumn) {
            this.executeDDL(ddls.toString());
        }
    }

    private String detectedColumnTypeByClassType(Class<?> typeClazz, String columnName) {
        String typeName = typeClazz.getName();
        String typeDef = null;
        switch (typeName) {
            case "int": {
                typeDef = "INTEGER";
                break;
            }
            case "java.lang.Integer": {
                typeDef = "INTEGER";
                break;
            }
            case "long": {
                typeDef = "numeric(32,0)";
                break;
            }
            case "java.lang.Long": {
                typeDef = "numeric(32,0)";
                break;
            }
            case "double": {
                typeDef = "double";
                break;
            }
            case "java.lang.Double": {
                typeDef = "double";
                break;
            }
            case "float": {
                typeDef = "float4";
                break;
            }
            case "java.lang.Float": {
                typeDef = "float4";
                break;
            }
            case "boolean": {
                typeDef = "bool";
                break;
            }
            case "java.lang.Boolean": {
                typeDef = "bool";
                break;
            }
            case "java.lang.String": {
                typeDef = "id".equals(columnName) ? "VARCHAR(64)" : "VARCHAR(64)";
                break;
            }
            case "java.util.Date": {
                typeDef = "DATETIME";
                break;
            }
            case "java.math.BigDecimal": {
                typeDef = "numeric(32,2)";
                break;
            }
            default: {
                typeDef = "VARCHAR(1024)";
            }
        }
        return typeDef;
    }

    public static String change2dbFormat(String prop) {
        StringBuffer sb = new StringBuffer(prop);
        int len = sb.length();
        for (int i = 1; i < len; ++i) {
            if (!SPLIT_WORDS.contains("" + sb.charAt(i))) continue;
            sb.insert(i, "_");
            ++i;
            ++len;
        }
        return sb.toString();
    }

    private boolean columnExist(String tableName, String columnName) {
        if ("id".equalsIgnoreCase(columnName)) {
            return true;
        }
        return EXIST_COLUMN_NAME.containsKey(tableName.toLowerCase() + "/" + columnName.toLowerCase());
    }

    @Override
    public boolean setDOList(Collection<BaseDO> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        this.doList = new ArrayList<BaseDO>();
        this.doList.addAll(collection);
        return true;
    }

    @Override
    public void closeConn() {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

