/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import com.alibaba.fastjson2.JSON;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import tech.codingless.core.plugs.mybaties3.ConcurrentSqlCreatorLocker;
import tech.codingless.core.plugs.mybaties3.GenericUpdateDao;
import tech.codingless.core.plugs.mybaties3.MyBatiesService;
import tech.codingless.core.plugs.mybaties3.conf.DataBaseConf;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.data.UpdateObject;
import tech.codingless.core.plugs.mybaties3.helper.AutoCreateBatchHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoDeleteBatchHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoUpdateHelper;
import tech.codingless.core.plugs.mybaties3.helper.CommonSQLHelper;
import tech.codingless.core.plugs.mybaties3.helper.MyTypeHanderRegistHelper;
import tech.codingless.core.plugs.mybaties3.helper.PrepareParameterHelper;
import tech.codingless.core.plugs.mybaties3.helper.UpdateSkipNullBatchAppendHelper;
import tech.codingless.core.plugs.mybaties3.util.DataSessionEnv;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

@Component
public class GenericUpdateDAOImpl<T extends BaseDO>
implements GenericUpdateDao<T> {
    private static final String NAMESPACE = "AUTOSQL";
    private static final Logger LOG = LoggerFactory.getLogger(GenericUpdateDAOImpl.class);
    protected MyBatiesService myBatiesService;
    protected BasicDataSource basicDataSource;
    @Autowired(required=false)
    private DataBaseConf conf;

    @Autowired
    protected void setMyBatiesService(MyBatiesService myBatiesService) {
        LOG.info("Jnjection Data Access Service: {}", (Object)myBatiesService);
        this.myBatiesService = myBatiesService;
        if (this.conf != null && MybatiesStringUtil.isNotEmpty(this.conf.getUrl(), this.conf.getUsername(), this.conf.getPassword())) {
            this.basicDataSource = new BasicDataSource();
            this.basicDataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
            this.basicDataSource.setUrl(this.conf.getUrl());
            this.basicDataSource.setUsername(this.conf.getUsername());
            this.basicDataSource.setPassword(this.conf.getPassword());
            this.basicDataSource.setMaxIdle(30);
            this.basicDataSource.setMinIdle(3);
            this.basicDataSource.setMaxTotal(30);
            this.basicDataSource.setMaxWaitMillis(10000L);
            this.basicDataSource.setInitialSize(3);
            this.basicDataSource.setRemoveAbandonedOnBorrow(true);
            this.basicDataSource.setRemoveAbandonedTimeout(180);
            LOG.info("Create BasicDataSource : {}", (Object)this.basicDataSource);
        }
    }

    @Override
    public int update(String sqlId, Object param) {
        return this.myBatiesService.update(sqlId, param);
    }

    @Override
    public int insert(String sqlId, Object param) {
        return this.myBatiesService.insert(sqlId, param);
    }

    @Override
    public int delete(String sqlId, Object param) {
        return this.myBatiesService.delete(sqlId, param);
    }

    public void genAutoSqlForCreate(Object entity) {
        try {
            MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), entity.getClass());
            String sqlKey = "AUTOSQL.CREATE_" + CommonSQLHelper.getTableName(entity);
            SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
            SqlSource sqlSource = sqlSourceBuilder.parse(CommonSQLHelper.getInsertSQL(entity), entity.getClass(), null);
            MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.INSERT);
            this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
            if (LOG.isDebugEnabled()) {
                LOG.debug("gen script : " + CommonSQLHelper.getInsertSQL(entity));
            }
        }
        catch (Exception e) {
            LOG.error("genAutoSqlForCreate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createEntity(Object entity) {
        String sqlKey = "AUTOSQL.CREATE_" + CommonSQLHelper.getTableName(entity);
        try {
            return this.myBatiesService.insert(sqlKey, entity);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        this.genAutoSqlForCreate(entity);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.insert(sqlKey, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createEntityList(List<T> entityList) {
        String sqlKey = "AUTOSQL.CREATE_BATCH_" + CommonSQLHelper.getTableName(entityList.get(0));
        try {
            return this.myBatiesService.insert(sqlKey, entityList);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoCreateBatchHelper.genBatchCreateSql(this.myBatiesService.getConfiguration(), NAMESPACE, sqlKey, ((BaseDO)entityList.get(0)).getClass());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.insert(sqlKey, entityList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteEntity(Class<T> clazz, String entityId) {
        String sqlKey = "AUTOSQL.DELETE_" + CommonSQLHelper.getTableName(clazz);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("entityId", entityId);
        p.put("del_user", DataSessionEnv.CURRENT_USER_ID.get());
        try {
            return this.myBatiesService.delete(sqlKey, p);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
                        String deleteSQL = CommonSQLHelper.getDeleteSQL(clazz);
                        LOG.info("[\u52a8\u6001\u751f\u6210SQL\u8bed\u53e5] " + deleteSQL);
                        SqlSource sqlSource = sqlSourceBuilder.parse(deleteSQL, Map.class, null);
                        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.DELETE);
                        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.delete(sqlKey, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteEntityWithCompanyId(Class<T> clazz, String id, String companyId) {
        String sqlKey = "AUTOSQL.DELETE_WIDTH_COMPANY_ID" + CommonSQLHelper.getTableName(clazz);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("entityId", id);
        p.put("company_id", companyId);
        try {
            return this.myBatiesService.delete(sqlKey, p);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
                        String deleteSQL = CommonSQLHelper.getDeleteWithCompanyIdSQL(clazz);
                        LOG.info("[\u52a8\u6001\u751f\u6210SQL\u8bed\u53e5] " + deleteSQL);
                        SqlSource sqlSource = sqlSourceBuilder.parse(deleteSQL, Map.class, null);
                        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.DELETE);
                        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.delete(sqlKey, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteLogicalWithCompanyId(Class<T> clazz, String id, String companyId) {
        String sqlKey = "AUTOSQL.DELETE_LOGICAL_WIDTH_COMPANY_ID" + CommonSQLHelper.getTableName(clazz);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("entityId", id);
        p.put("company_id", companyId);
        try {
            return this.myBatiesService.update(sqlKey, p);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
                        String deleteSQL = CommonSQLHelper.getDeleteLogicalWithCompanyIdSQL(clazz);
                        LOG.info("[\u52a8\u6001\u751f\u6210SQL\u8bed\u53e5] " + deleteSQL);
                        SqlSource sqlSource = sqlSourceBuilder.parse(deleteSQL, Map.class, null);
                        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.DELETE);
                        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.update(sqlKey, p);
        }
    }

    @Override
    public int deleteLogicalWithCompanyId(Class<T> clazz, Collection<String> idList, String companyId) {
        return AutoDeleteBatchHelper.deleteLogical(this.myBatiesService, clazz, idList, companyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateEntity(BaseDO entiry) {
        String sqlKey = "AUTOSQL.UPDATE_" + CommonSQLHelper.getTableName(entiry);
        try {
            return this.myBatiesService.update(sqlKey, entiry);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        this.genAutoSqlForUpdate(entiry);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.update(sqlKey, entiry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateEntityWithCompanyId(BaseDO entiry, String companyId) {
        String sqlKey = "AUTOSQL.UPDATE_WITH_COMPANY_ID" + CommonSQLHelper.getTableName(entiry);
        entiry.setCompanyId(companyId);
        try {
            return this.myBatiesService.update(sqlKey, entiry);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
                        String updateSQL = CommonSQLHelper.getUpdateSQLWithCompanyId(entiry.getClass());
                        SqlSource sqlSource = sqlSourceBuilder.parse(updateSQL, entiry.getClass(), null);
                        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.UPDATE);
                        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
                        if (LOG.isDebugEnabled()) {
                            LOG.info("[\u52a8\u6001\u751f\u6210SQL\u8bed\u53e5] " + updateSQL);
                        }
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.update(sqlKey, entiry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateNotNull(T data, Long ver) {
        String sqlId = "UPDATE_SKIP_NULLV2_" + CommonSQLHelper.getTableName(data);
        String sqlKey = NAMESPACE.concat(".").concat(sqlId);
        try {
            ((BaseDO)data).setVer(ver);
            return this.myBatiesService.update(sqlKey, data);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoUpdateHelper.genUpdateSkipNullSql(this.myBatiesService.getConfiguration(), NAMESPACE, sqlId, data.getClass());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.update(sqlKey, data);
        }
    }

    @Override
    public int updateSkipNullBatchAppend(String companyId, T data, Long ver, int batchSize) {
        return UpdateSkipNullBatchAppendHelper.updateSkipNullBatchAppend(this.myBatiesService, companyId, data, ver, batchSize);
    }

    @Override
    public int updateSkipNullBatchExecute(Class<T> clazz) {
        return UpdateSkipNullBatchAppendHelper.updateSkipNullBatchExecute(this.myBatiesService, clazz);
    }

    @Override
    public int updateSkipNullBatchExecute(List<UpdateObject> updateList) {
        return UpdateSkipNullBatchAppendHelper.updateSkipNullBatchExecute(this.myBatiesService, updateList);
    }

    public void genAutoSqlForUpdate(BaseDO entiry) {
        String sqlKey = "AUTOSQL.UPDATE_" + CommonSQLHelper.getTableName(entiry);
        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
        String updateSQL = CommonSQLHelper.getUpdateSQL(entiry.getClass());
        SqlSource sqlSource = sqlSourceBuilder.parse(updateSQL, entiry.getClass(), null);
        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.UPDATE);
        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("[\u52a8\u6001\u751f\u6210SQL\u8bed\u53e5] " + updateSQL);
        }
    }

    @Override
    public int insertNative(String sql, List<Object> params) {
        try (Connection conn = this.basicDataSource.getConnection();){
            PreparedStatement pstmt = conn.prepareStatement(sql);
            PrepareParameterHelper.bindParam(pstmt, params);
            pstmt.execute();
            if (LOG.isDebugEnabled()) {
                LOG.info("insertNative:{},PARAM:{}", (Object)sql, (Object)(!CollectionUtils.isEmpty(params) ? JSON.toJSONString(params) : "NONE"));
            }
        }
        catch (SQLException e) {
            LOG.error("insertNative", (Throwable)e);
        }
        return 1;
    }

    @Override
    public int updateNative(String prepareSql, List<Object> params) {
        int n;
        block9: {
            Connection conn = this.basicDataSource.getConnection();
            try {
                PreparedStatement pstmt = conn.prepareStatement(prepareSql);
                PrepareParameterHelper.bindParam(pstmt, params);
                int effect = pstmt.executeUpdate();
                if (LOG.isDebugEnabled()) {
                    LOG.info("updateNative:{},PARAM:{}", (Object)prepareSql, (Object)(!CollectionUtils.isEmpty(params) ? JSON.toJSONString(params) : "NONE"));
                }
                n = effect;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOG.error("updateNative", (Throwable)e);
                    return 0;
                }
            }
            conn.close();
        }
        return n;
    }
}

