/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import tech.codingless.core.plugs.mybaties3.GenericUpdateDAOImpl;
import tech.codingless.core.plugs.mybaties3.MyBatiesService;
import tech.codingless.core.plugs.mybaties3.TableAutoCreateService;
import tech.codingless.core.plugs.mybaties3.conf.DataBaseConf;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.helper.AutoFindByIdHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoGetHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoRollpageV2Helper;
import tech.codingless.core.plugs.mybaties3.helper.AutoUpdateHelper;
import tech.codingless.core.plugs.mybaties3.helper.MyTypeHanderRegistHelper;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class DBInitSpringListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUpdateDAOImpl.class);
    @Autowired
    private TableAutoCreateService tableAutoCreateService;
    @Autowired
    ApplicationEventPublisher eventPublisher;
    @Autowired
    ApplicationContext context;
    @Autowired
    private MyBatiesService myBatiesService;
    @Autowired
    private GenericUpdateDAOImpl<?> updateScriptGen;
    @Autowired(required=false)
    private DataBaseConf conf;
    @Value(value="${tech.codingless.biz.core.createtable:1}")
    private String isautocreate;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        LOG.info("\u76d1\u542c\u5230  Spring  \u542f\u52a8.");
        LOG.info("ApplicationStartedEvent_DBInitSpringListener");
        Map map = this.context.getBeansOfType(BaseDO.class);
        if (map != null && !map.isEmpty()) {
            this.tableAutoCreateService.setDOList(map.values());
        }
        if (this.conf != null && this.conf.needAutoCreateTable() && MybatiesStringUtil.isNotEmpty(this.conf.getUrl(), this.conf.getUsername(), this.conf.getPassword())) {
            LOG.info("\u81ea\u52a8\u540c\u6b65\u8868\u7ed3\u6784");
            this.tableAutoCreateService.setUrl(this.conf.getUrl());
            this.tableAutoCreateService.setUsername(this.conf.getUsername());
            this.tableAutoCreateService.setPassword(this.conf.getPassword());
            this.tableAutoCreateService.create();
            this.tableAutoCreateService.closeConn();
        }
        map.values().forEach(dataobject -> MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), dataobject.getClass()));
        map.values().forEach(entity -> {
            this.updateScriptGen.genAutoSqlForCreate(entity);
            this.updateScriptGen.genAutoSqlForUpdate((BaseDO)entity);
            AutoGetHelper.genAutoSqlForGet(entity.getClass(), false, this.myBatiesService.getConfiguration());
            AutoUpdateHelper.genUpdateSkipNullSql(this.myBatiesService.getConfiguration(), entity.getClass());
            AutoFindByIdHelper.genGetSql(this.myBatiesService.getConfiguration(), entity.getClass());
            AutoRollpageV2Helper.genSql(this.myBatiesService.getConfiguration(), entity.getClass());
        });
    }
}

