/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallEvnUtl {
    private static final Logger LOG = LoggerFactory.getLogger(InstallEvnUtl.class);
    private static final ConcurrentHashMap<String, String> APPLICATION_PROPETIES_CACHE = new ConcurrentHashMap();

    public static void main(String[] args) {
        System.out.println(InstallEvnUtl.getProperites("a", "b"));
    }

    public static String getApplicationProperites(String key) {
        return InstallEvnUtl.getApplicationProperites(key, "test").get(key);
    }

    public static Map<String, String> getApplicationProperites(String ... keys) {
        if (APPLICATION_PROPETIES_CACHE.isEmpty()) {
            try {
                Properties prop = new Properties();
                prop.load(InstallEvnUtl.class.getResourceAsStream("/application.properties"));
                for (Object e : prop.keySet()) {
                    APPLICATION_PROPETIES_CACHE.put(e.toString(), prop.getProperty(e.toString()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : keys) {
            result.put(key, APPLICATION_PROPETIES_CACHE.get(key));
        }
        return result;
    }

    public static Map<String, String> getProperites(String ... keys) {
        if (keys == null) {
            return new HashMap<String, String>();
        }
        File propfile = new File(System.getProperty("user.home") + File.separator + ".io.uni.biz.propties");
        if (!propfile.exists()) {
            LOG.info("Not Found Install Propties File {}", (Object)propfile.getAbsolutePath());
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(propfile));
            List.of(keys).forEach(key -> map.put((String)key, prop.getProperty((String)key, "")));
        }
        catch (Exception e) {
            LOG.error("Load Propties File Error ", (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> getByPrefix(String prefix) {
        if (APPLICATION_PROPETIES_CACHE.isEmpty()) {
            try {
                Properties prop = new Properties();
                prop.load(InstallEvnUtl.class.getResourceAsStream("/application.properties"));
                for (Object key2 : prop.keySet()) {
                    APPLICATION_PROPETIES_CACHE.put(key2.toString(), prop.getProperty(key2.toString()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        APPLICATION_PROPETIES_CACHE.keys().asIterator().forEachRemaining(key -> {
            if (key.startsWith(prefix)) {
                result.put((String)key, APPLICATION_PROPETIES_CACHE.get(key));
            }
        });
        return result;
    }
}

