/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.helper;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import tech.codingless.core.gateway.data.MyMemoryAnalysisFlag;
import tech.codingless.core.gateway.util.StackTraceUtil;

public class RequestMonitorHelper {
    private static ConcurrentHashMap<String, RequestAnalysis> CACHE = new ConcurrentHashMap();
    private static ConcurrentHashMap<MyMemoryAnalysisFlag, Long> FLAGS = new ConcurrentHashMap();
    private static int MAX_NORMALS_SIZE = 20;
    private static int MAX_ERRORS_SIZE = 20;

    public static ConcurrentHashMap<String, RequestAnalysis> getAllLog() {
        return CACHE;
    }

    public static List<RequestAnalysis> getLog(String subUri) {
        ArrayList<RequestAnalysis> list = new ArrayList<RequestAnalysis>();
        Enumeration<String> keys = CACHE.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.contains(subUri)) continue;
            list.add(CACHE.get(key));
        }
        return list;
    }

    public static void clear() {
        CACHE.clear();
    }

    public static RequestLog findByRequestId(String requestId) {
        for (RequestAnalysis req : CACHE.values()) {
            for (RequestLog reqLog : req.getNormals()) {
                if (!requestId.equals(reqLog.getReqId())) continue;
                return reqLog;
            }
            for (RequestLog reqLog : req.getErrors()) {
                if (!requestId.equals(reqLog.getReqId())) continue;
                return reqLog;
            }
        }
        return null;
    }

    public static void append(String companyId, String userId, String userName, String reqId, String uri, String url, long cost, String urlParam, String reqBody, String response, Exception e) {
        RequestAnalysis ra = CACHE.get(uri);
        if (ra == null) {
            ra = new RequestAnalysis();
            ra.setUri(uri);
            ra.setCost(0L);
            ra.setTimes(0L);
            ra.setNormals(new LinkedList<RequestLog>());
            ra.setErrors(new LinkedList<RequestLog>());
            CACHE.put(uri, ra);
        }
        ra.setCost(ra.getCost() + cost);
        ra.setTimes(ra.getTimes() + 1L);
        RequestLog log = new RequestLog();
        log.setUrl(url);
        log.setCompanyId(companyId);
        log.setUserId(userId);
        log.setUserName(userName);
        log.setT(System.currentTimeMillis());
        log.setReqId(reqId);
        log.setCost(cost);
        log.setUrlParam(urlParam);
        log.setReqBody(reqBody);
        log.setResponse(response);
        if (e != null) {
            if (ra.getErrors().size() > MAX_ERRORS_SIZE) {
                ra.getErrors().pollLast();
            }
            ra.getErrors().push(log);
            log.setExceptionTrace(StackTraceUtil.format(e));
        } else {
            if (ra.getNormals().size() > MAX_NORMALS_SIZE) {
                ra.getNormals().pollLast();
            }
            ra.getNormals().push(log);
        }
    }

    public static void append(MyMemoryAnalysisFlag myMemoryAnalysisFlag) {
        FLAGS.put(myMemoryAnalysisFlag, System.currentTimeMillis());
    }

    public static void clear(MyMemoryAnalysisFlag myMemoryAnalysisFlag) {
        if (myMemoryAnalysisFlag == null) {
            return;
        }
        FLAGS.remove(myMemoryAnalysisFlag);
    }

    public static ConcurrentHashMap<MyMemoryAnalysisFlag, Long> activeReqs() {
        return FLAGS;
    }

    public static class RequestLog {
        private String url;
        private long cost;
        private long t;
        private String companyId;
        private String userId;
        private String userName;
        private String reqId;
        private String urlParam;
        private String reqBody;
        private String response;
        private String exceptionTrace;

        public String getUrl() {
            return this.url;
        }

        public long getCost() {
            return this.cost;
        }

        public long getT() {
            return this.t;
        }

        public String getCompanyId() {
            return this.companyId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getReqId() {
            return this.reqId;
        }

        public String getUrlParam() {
            return this.urlParam;
        }

        public String getReqBody() {
            return this.reqBody;
        }

        public String getResponse() {
            return this.response;
        }

        public String getExceptionTrace() {
            return this.exceptionTrace;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public void setT(long t) {
            this.t = t;
        }

        public void setCompanyId(String companyId) {
            this.companyId = companyId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setReqId(String reqId) {
            this.reqId = reqId;
        }

        public void setUrlParam(String urlParam) {
            this.urlParam = urlParam;
        }

        public void setReqBody(String reqBody) {
            this.reqBody = reqBody;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public void setExceptionTrace(String exceptionTrace) {
            this.exceptionTrace = exceptionTrace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestLog)) {
                return false;
            }
            RequestLog other = (RequestLog)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCost() != other.getCost()) {
                return false;
            }
            if (this.getT() != other.getT()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$companyId = this.getCompanyId();
            String other$companyId = other.getCompanyId();
            if (this$companyId == null ? other$companyId != null : !this$companyId.equals(other$companyId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$reqId = this.getReqId();
            String other$reqId = other.getReqId();
            if (this$reqId == null ? other$reqId != null : !this$reqId.equals(other$reqId)) {
                return false;
            }
            String this$urlParam = this.getUrlParam();
            String other$urlParam = other.getUrlParam();
            if (this$urlParam == null ? other$urlParam != null : !this$urlParam.equals(other$urlParam)) {
                return false;
            }
            String this$reqBody = this.getReqBody();
            String other$reqBody = other.getReqBody();
            if (this$reqBody == null ? other$reqBody != null : !this$reqBody.equals(other$reqBody)) {
                return false;
            }
            String this$response = this.getResponse();
            String other$response = other.getResponse();
            if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
                return false;
            }
            String this$exceptionTrace = this.getExceptionTrace();
            String other$exceptionTrace = other.getExceptionTrace();
            return !(this$exceptionTrace == null ? other$exceptionTrace != null : !this$exceptionTrace.equals(other$exceptionTrace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestLog;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cost = this.getCost();
            result = result * 59 + (int)($cost >>> 32 ^ $cost);
            long $t = this.getT();
            result = result * 59 + (int)($t >>> 32 ^ $t);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $companyId = this.getCompanyId();
            result = result * 59 + ($companyId == null ? 43 : $companyId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $reqId = this.getReqId();
            result = result * 59 + ($reqId == null ? 43 : $reqId.hashCode());
            String $urlParam = this.getUrlParam();
            result = result * 59 + ($urlParam == null ? 43 : $urlParam.hashCode());
            String $reqBody = this.getReqBody();
            result = result * 59 + ($reqBody == null ? 43 : $reqBody.hashCode());
            String $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            String $exceptionTrace = this.getExceptionTrace();
            result = result * 59 + ($exceptionTrace == null ? 43 : $exceptionTrace.hashCode());
            return result;
        }

        public String toString() {
            return "RequestMonitorHelper.RequestLog(url=" + this.getUrl() + ", cost=" + this.getCost() + ", t=" + this.getT() + ", companyId=" + this.getCompanyId() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", reqId=" + this.getReqId() + ", urlParam=" + this.getUrlParam() + ", reqBody=" + this.getReqBody() + ", response=" + this.getResponse() + ", exceptionTrace=" + this.getExceptionTrace() + ")";
        }
    }

    public static class RequestAnalysis {
        private String uri;
        private long cost;
        private long times;
        private LinkedList<RequestLog> normals;
        private LinkedList<RequestLog> errors;

        public String getUri() {
            return this.uri;
        }

        public long getCost() {
            return this.cost;
        }

        public long getTimes() {
            return this.times;
        }

        public LinkedList<RequestLog> getNormals() {
            return this.normals;
        }

        public LinkedList<RequestLog> getErrors() {
            return this.errors;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public void setTimes(long times) {
            this.times = times;
        }

        public void setNormals(LinkedList<RequestLog> normals) {
            this.normals = normals;
        }

        public void setErrors(LinkedList<RequestLog> errors) {
            this.errors = errors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestAnalysis)) {
                return false;
            }
            RequestAnalysis other = (RequestAnalysis)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCost() != other.getCost()) {
                return false;
            }
            if (this.getTimes() != other.getTimes()) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            LinkedList<RequestLog> this$normals = this.getNormals();
            LinkedList<RequestLog> other$normals = other.getNormals();
            if (this$normals == null ? other$normals != null : !((Object)this$normals).equals(other$normals)) {
                return false;
            }
            LinkedList<RequestLog> this$errors = this.getErrors();
            LinkedList<RequestLog> other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestAnalysis;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cost = this.getCost();
            result = result * 59 + (int)($cost >>> 32 ^ $cost);
            long $times = this.getTimes();
            result = result * 59 + (int)($times >>> 32 ^ $times);
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            LinkedList<RequestLog> $normals = this.getNormals();
            result = result * 59 + ($normals == null ? 43 : ((Object)$normals).hashCode());
            LinkedList<RequestLog> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            return result;
        }

        public String toString() {
            return "RequestMonitorHelper.RequestAnalysis(uri=" + this.getUri() + ", cost=" + this.getCost() + ", times=" + this.getTimes() + ", normals=" + this.getNormals() + ", errors=" + this.getErrors() + ")";
        }
    }
}

