/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.codingless.core.gateway.util.StringUtil;

public class ModuleConf {
    private List<Module> modules;

    public static ModuleConf build(Map<String, String> properties) {
        ModuleConf conf = new ModuleConf();
        conf.setModules(new ArrayList<Module>());
        HashMap tmp = new HashMap();
        properties.keySet().forEach(key -> {
            String name = key.substring("tech.codingless.modules".length());
            if (StringUtil.isEmpty(name)) {
                return;
            }
            String[] group = name.split("[.]", 2);
            if (group.length != 2) {
                return;
            }
            if (!tmp.containsKey(group[0])) {
                tmp.put(group[0], new HashMap());
            }
            ((Map)tmp.get(group[0])).put(group[1], (String)properties.get(key));
        });
        tmp.keySet().forEach(key -> {
            Map attr = (Map)tmp.get(key);
            Module module = new Module();
            module.setEnable("true".equalsIgnoreCase((String)attr.get("enable")));
            module.setName((String)attr.get("name"));
            module.setPkg((String)attr.get("pkg"));
            conf.getModules().add(module);
        });
        return conf;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleConf)) {
            return false;
        }
        ModuleConf other = (ModuleConf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Module> this$modules = this.getModules();
        List<Module> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleConf;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Module> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    public String toString() {
        return "ModuleConf(modules=" + this.getModules() + ")";
    }

    public static class Module {
        private String name;
        private boolean enable;
        private String pkg;

        public String getName() {
            return this.name;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getPkg() {
            return this.pkg;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Module)) {
                return false;
            }
            Module other = (Module)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnable() != other.isEnable()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            return !(this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Module;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnable() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            return result;
        }

        public String toString() {
            return "ModuleConf.Module(name=" + this.getName() + ", enable=" + this.isEnable() + ", pkg=" + this.getPkg() + ")";
        }
    }
}

