/*
 * Decompiled with CFR 0.152.
 */
package tech.checkhim.exceptions;

public class CheckHimException
extends Exception {
    private final String errorCode;
    private final int httpStatusCode;

    public CheckHimException(String message) {
        super(message);
        this.errorCode = null;
        this.httpStatusCode = 0;
    }

    public CheckHimException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = null;
        this.httpStatusCode = 0;
    }

    public CheckHimException(String message, String errorCode, int httpStatusCode) {
        super(message);
        this.errorCode = errorCode;
        this.httpStatusCode = httpStatusCode;
    }

    public CheckHimException(String message, String errorCode, int httpStatusCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.httpStatusCode = httpStatusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean isClientError() {
        return this.httpStatusCode >= 400 && this.httpStatusCode < 500;
    }

    public boolean isServerError() {
        return this.httpStatusCode >= 500 && this.httpStatusCode < 600;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(": ").append(this.getMessage());
        if (this.errorCode != null) {
            sb.append(" [").append(this.errorCode).append("]");
        }
        if (this.httpStatusCode > 0) {
            sb.append(" (HTTP ").append(this.httpStatusCode).append(")");
        }
        return sb.toString();
    }
}

