/*
 * Decompiled with CFR 0.152.
 */
package tech.checkhim;

import tech.checkhim.exceptions.CheckHimException;
import tech.checkhim.http.HttpClient;
import tech.checkhim.models.VerificationRequest;
import tech.checkhim.models.VerificationResponse;

public class CheckHim {
    private static final String DEFAULT_BASE_URL = "https://api.checkhim.tech";
    private static final String API_VERSION = "v1";
    private final HttpClient httpClient;
    private final String apiKey;
    private final String baseUrl;

    public CheckHim(String apiKey) {
        this(apiKey, DEFAULT_BASE_URL);
    }

    public CheckHim(String apiKey, String baseUrl) {
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key cannot be null or empty");
        }
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Base URL cannot be null or empty");
        }
        this.apiKey = apiKey.trim();
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.httpClient = new HttpClient(this.apiKey, this.baseUrl);
    }

    public VerificationResponse verify(VerificationRequest request) throws CheckHimException {
        if (request == null) {
            throw new IllegalArgumentException("VerificationRequest cannot be null");
        }
        String endpoint = String.format("/api/%s/verify", API_VERSION);
        return this.httpClient.post(endpoint, request, VerificationResponse.class);
    }

    public VerificationResponse verify(String phoneNumber) throws CheckHimException {
        if (phoneNumber == null || phoneNumber.trim().isEmpty()) {
            throw new IllegalArgumentException("Phone number cannot be null or empty");
        }
        VerificationRequest request = VerificationRequest.builder().number(phoneNumber.trim()).build();
        return this.verify(request);
    }

    public String getApiKey() {
        if (this.apiKey.length() <= 8) {
            return "*".repeat(this.apiKey.length());
        }
        return this.apiKey.substring(0, 4) + "*".repeat(this.apiKey.length() - 8) + this.apiKey.substring(this.apiKey.length() - 4);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

