/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.platform.tx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.SystemErrorEnum;

@Component
public class JellyTxTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JellyTxTemplate.class);
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public <T> T execute(TransactionCallback<T> callback) {
        TransactionStatus status;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("tx execute start");
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        def.setTimeout(30);
        try {
            status = this.platformTransactionManager.getTransaction((TransactionDefinition)def);
        }
        catch (JellyException e) {
            LOGGER.warn("getTransaction throw Exception", (Throwable)e);
            throw new JellyException(e.getError());
        }
        catch (Exception e) {
            LOGGER.error("getTransaction throw Exception", (Throwable)e);
            throw new JellyException(SystemErrorEnum.SYSTEM_ERROR.getError(new Object[0]));
        }
        Object result = null;
        try {
            result = callback.doInTransaction(status);
        }
        catch (RuntimeException re) {
            LOGGER.error("throw RuntimeException", (Throwable)re);
            this.rollbackOnException(status, re);
        }
        catch (Error err) {
            LOGGER.error("throw Error", (Throwable)err);
            this.rollbackOnException(status, err);
        }
        catch (Exception e) {
            LOGGER.error("throw Exception", (Throwable)e);
            this.rollbackOnException(status, e);
        }
        try {
            this.platformTransactionManager.commit(status);
        }
        catch (Exception e) {
            LOGGER.error("commit throw Exception", (Throwable)e);
            throw new JellyException(SystemErrorEnum.SYSTEM_ERROR.getError(new Object[0]));
        }
        return (T)result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws JellyException {
        try {
            this.platformTransactionManager.rollback(status);
        }
        catch (JellyException e) {
            LOGGER.warn("getTransaction throw Exception", (Throwable)e);
            throw new JellyException(e.getError());
        }
        catch (TransactionSystemException tse) {
            LOGGER.error("rollback throw TransactionSystemException", (Throwable)tse);
            tse.initApplicationException(ex);
            throw new JellyException(SystemErrorEnum.SYSTEM_ERROR.getError(new Object[0]));
        }
        catch (RuntimeException re) {
            LOGGER.error("rollback throw Exception", (Throwable)re);
        }
        catch (Error err) {
            LOGGER.error("rollback throw Error", (Throwable)err);
        }
        if (ex instanceof JellyException) {
            JellyException ex2 = (JellyException)ex;
            LOGGER.warn("getTransaction throw Exception", (Throwable)ex2);
            throw new JellyException(ex2.getError());
        }
        throw new JellyException(SystemErrorEnum.SYSTEM_ERROR.getError(new Object[0]));
    }
}

