/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.platform.retry;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryHelper.class);
    private static final long NORMAL_INTERVAL = 10L;
    private static final int NORMAL_RETRY_TIMES = 10;
    private static final Retryer<Boolean> NORMAL_RETRYER = RetryerBuilder.newBuilder().retryIfException().retryIfResult(result -> {
        if (result == null) {
            return true;
        }
        return result == false;
    }).withWaitStrategy(WaitStrategies.fixedWait((long)10L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)10)).build();

    public static Retryer<Boolean> getNormalRetryer() {
        return NORMAL_RETRYER;
    }
}

