/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.platform.dal.converters;

import com.alibaba.fastjson.JSONObject;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaJsonConverter
implements AttributeConverter<JSONObject, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaJsonConverter.class);

    public String convertToDatabaseColumn(JSONObject attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return attribute.toJSONString();
        }
        catch (Exception e) {
            LOGGER.warn("convert attr to db value failed: {}", (Object)attribute.getClass().getName());
            return null;
        }
    }

    public JSONObject convertToEntityAttribute(String dbData) {
        if (StringUtils.isEmpty((CharSequence)dbData)) {
            return null;
        }
        try {
            return JSONObject.parseObject((String)dbData);
        }
        catch (Exception e) {
            LOGGER.warn("convert db value to attr failed: {}", (Object)dbData);
            return null;
        }
    }
}

