/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.platform.access.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.SystemErrorEnum;
import tech.bitstwinkle.jelly.commons.ids.JellyIds;
import tech.bitstwinkle.jelly.commons.proto.Meta;
import tech.bitstwinkle.jelly.commons.proto.Request;
import tech.bitstwinkle.jelly.commons.proto.Response;

@Aspect
@Component
public class AccessEntranceAspect {
    private static final Logger SERVER_DIGEST = LoggerFactory.getLogger((String)"SERVER-DIGEST");

    @Pointcut(value="@annotation(tech.bitstwinkle.jelly.platform.access.annotation.AccessEntrance)")
    public void accessEntrance() {
    }

    @Around(value="accessEntrance()")
    public Object aroundAccessEntrance(ProceedingJoinPoint proceedingJoinPoint) {
        Object respResult;
        String clazz = proceedingJoinPoint.getTarget().getClass().getSimpleName();
        String method = proceedingJoinPoint.getSignature().getName();
        Meta requestMeta = null;
        try {
            requestMeta = this.doBefore((JoinPoint)proceedingJoinPoint, method);
            long start = System.currentTimeMillis();
            respResult = proceedingJoinPoint.proceed();
            long end = System.currentTimeMillis();
            SERVER_DIGEST.info("I - {}.{} - Execution time:{} ms", new Object[]{proceedingJoinPoint.getTarget().getClass().getSimpleName(), method, end - start});
            this.doAfter(clazz, method, respResult);
        }
        catch (JellyException ex) {
            SERVER_DIGEST.info("E - {}.{} : {}@{}", new Object[]{clazz, method, ex.getError().getCode(), ex.getError().getMessage()});
            respResult = new Response(ex.getError());
        }
        catch (Throwable thr) {
            SERVER_DIGEST.info("E - {}.{} : {}", new Object[]{clazz, method, thr});
            respResult = new Response(SystemErrorEnum.SYSTEM_ERROR.getError(new Object[0]));
        }
        if (respResult != null && respResult instanceof Response) {
            Meta respMeta = new Meta();
            if (requestMeta != null) {
                respMeta.setRequestId(requestMeta.getRequestId());
                respMeta.setTraceId(requestMeta.getTraceId());
            } else {
                respMeta.setRequestId("no-src-requestId");
                respMeta.setTraceId(JellyIds.uniqueId());
            }
            respMeta.setDt(System.currentTimeMillis());
            ((Response)respResult).setMeta(respMeta);
        }
        return respResult;
    }

    private void doAfter(String clzName, String method, Object result) {
        if (result == null) {
            result = "void";
        }
        SERVER_DIGEST.info("O - {}.{} - Response: {}", new Object[]{clzName, method, result});
        MDC.remove((String)"traceId");
    }

    private Meta doBefore(JoinPoint joinPoint, String method) {
        Object[] args = joinPoint.getArgs();
        Request request = null;
        if (args != null && args[0] != null && args[0] instanceof Request) {
            request = (Request)args[0];
        }
        if (request == null) {
            SERVER_DIGEST.info("I - {}.{} : {}", new Object[]{joinPoint.getTarget().getClass().getSimpleName(), method, joinPoint.getArgs()});
            return null;
        }
        Meta meta = request.getMeta();
        if (meta != null) {
            MDC.put((String)"traceId", (String)meta.getTraceId());
        }
        SERVER_DIGEST.info("I - {}.{} : [{}]{}", new Object[]{joinPoint.getTarget().getClass().getSimpleName(), method, meta, joinPoint.getArgs()});
        return meta;
    }
}

