/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.idfactory;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bitstwinkle.jelly.idfactory.dal.SequenceEntity;
import tech.bitstwinkle.jelly.idfactory.dal.SequenceEntityRepository;
import tech.bitstwinkle.jelly.idfactory.domains.Section;
import tech.bitstwinkle.jelly.idfactory.domains.Sequence;
import tech.bitstwinkle.jelly.platform.retry.RetryHelper;
import tech.bitstwinkle.jelly.platform.tx.JellyTxTemplate;

public class LocalSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalSequence.class);
    private static final Retryer<Boolean> RETRYER = RetryHelper.getNormalRetryer();
    private final Sequence sequence;
    private final SequenceEntityRepository repository;
    private final JellyTxTemplate jellyTx;
    private Lock lock = new ReentrantLock();
    private AtomicLong localSeq = new AtomicLong();
    private Section section;

    public LocalSequence(Sequence sequence, SequenceEntityRepository repository, JellyTxTemplate jellyTx) {
        this.sequence = sequence;
        this.repository = repository;
        this.jellyTx = jellyTx;
    }

    public long nextSequence() {
        if (this.checkWhetherNeedRefresh()) {
            this.lock.lock();
            try {
                if (this.checkWhetherNeedRefresh()) {
                    RETRYER.call(() -> this.doRefreshLocalSection());
                }
            }
            catch (ExecutionException e) {
                LOGGER.error("Retry Execution Exception", (Throwable)e);
            }
            catch (RetryException e) {
                LOGGER.error("Retry Retry Exception", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.localSeq.getAndIncrement();
    }

    public String formatSequence(long seq) {
        return String.format("%04d", seq);
    }

    private SequenceEntity doInit() {
        LOGGER.info("init sequence: {}", (Object)this.sequence);
        SequenceEntity sequenceEntity = new SequenceEntity();
        sequenceEntity.setBizCode(this.sequence.getBizCode());
        sequenceEntity.setMin(this.sequence.getMin());
        sequenceEntity.setMax(this.sequence.getMax());
        sequenceEntity.setStep(this.sequence.getStep());
        sequenceEntity.setCurrent(this.sequence.getMax());
        this.jellyTx.execute(status -> {
            this.repository.saveAndFlush((Object)sequenceEntity);
            return true;
        });
        return sequenceEntity;
    }

    private boolean doRefreshLocalSection() {
        long dbNewCurrent;
        long current;
        LOGGER.info("refresh local section: " + this.section);
        Optional optional = this.repository.findById(this.sequence.getBizCode());
        SequenceEntity sequenceEntity = optional.orElseGet(this::doInit);
        this.sequence.setMin(sequenceEntity.getMin());
        this.sequence.setMax(sequenceEntity.getMax());
        this.sequence.setStep(sequenceEntity.getStep());
        long start = current = sequenceEntity.getCurrent();
        if (start > this.sequence.getMax()) {
            LOGGER.info("{} > {}, need restart", (Object)start, (Object)this.sequence.getMax());
            sequenceEntity.setCurrent(this.sequence.getMin());
            this.jellyTx.execute(status -> {
                this.repository.saveAndFlush((Object)sequenceEntity);
                return true;
            });
            return false;
        }
        long end = current + this.sequence.getStep();
        if (end > this.sequence.getMax()) {
            end = this.sequence.getMax();
        }
        if ((dbNewCurrent = end + 1L) > this.sequence.getMax()) {
            dbNewCurrent = this.sequence.getMin();
        }
        sequenceEntity.setCurrent(dbNewCurrent);
        this.jellyTx.execute(status -> {
            this.repository.saveAndFlush((Object)sequenceEntity);
            return true;
        });
        this.section = new Section(start, end);
        this.localSeq.set(this.section.getStart());
        LOGGER.info("current: {}|{}", (Object)this.section, (Object)this.localSeq);
        return true;
    }

    private boolean checkWhetherNeedRefresh() {
        return this.section == null || this.localSeq.get() > this.section.getEnd();
    }
}

