/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.idfactory;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bitstwinkle.jelly.idfactory.JellyIdGenerator;
import tech.bitstwinkle.jelly.idfactory.JellyIdHelper;
import tech.bitstwinkle.jelly.idfactory.LocalSequence;
import tech.bitstwinkle.jelly.idfactory.dal.SequenceEntityRepository;
import tech.bitstwinkle.jelly.idfactory.domains.Sequence;
import tech.bitstwinkle.jelly.platform.tx.JellyTxTemplate;

public class LocalJellyIdGenerator
implements JellyIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalJellyIdGenerator.class);
    private final DateTimeFormatter timestampTemplate;
    private final LocalSequence localSequence;
    private final SequenceEntityRepository repository;
    private final JellyTxTemplate jellyTx;

    LocalJellyIdGenerator(String timestampTemplate, Sequence sequence, SequenceEntityRepository repository, JellyTxTemplate jellyTx) {
        this.timestampTemplate = DateTimeFormatter.ofPattern(timestampTemplate);
        this.localSequence = new LocalSequence(sequence, repository, jellyTx);
        this.repository = repository;
        this.jellyTx = jellyTx;
        LOGGER.info("init LocalJellyIdGenerator: {}|{}", (Object)timestampTemplate, (Object)sequence);
    }

    @Override
    public String generateId() {
        String core = this.doGenerateCode(-1);
        return JellyIdHelper.generateWithFlag(core);
    }

    @Override
    public String generateId(int dbFlag) {
        JellyIdHelper.checkDbFlag(dbFlag);
        String core = this.doGenerateCode(dbFlag);
        return JellyIdHelper.generateWithFlag(core);
    }

    private String doGenerateCode(int dbFlag) {
        LocalDateTime localDateTime = LocalDateTime.now();
        String timestampStr = localDateTime.format(this.timestampTemplate);
        long seq = this.localSequence.nextSequence();
        String seqStr = this.localSequence.formatSequence(seq);
        if (dbFlag == -1) {
            return timestampStr + seqStr;
        }
        return timestampStr + seqStr + String.format("%02d", dbFlag);
    }
}

