/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.idfactory;

import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.SystemErrorEnum;

public final class JellyIdHelper {
    static String generateWithFlag(String core) {
        int len = core.length();
        char first = core.charAt(0);
        char end = core.charAt(len - 1);
        int flag = len * len + first * first + end * end + len * (first + end);
        return core + (flag %= 10);
    }

    public static boolean isValidId(String id) {
        if (id == null || id.isEmpty()) {
            return false;
        }
        String core = id.substring(0, id.length() - 1);
        String genId = JellyIdHelper.generateWithFlag(core);
        return id.endsWith(genId);
    }

    public static void checkDbFlag(int dbFlag) {
        if (dbFlag < 0 || dbFlag > 99) {
            throw new JellyException(SystemErrorEnum.SYSTEM_ERROR_WITH_MSG.getError(new Object[]{"invalid db-flag:" + dbFlag}));
        }
    }

    public static int getDbFlag(String id) {
        int len = id.length();
        int beginPos = len - 3;
        int endPos = len - 2;
        String dbFlagStr = id.substring(beginPos, endPos);
        return Integer.valueOf(dbFlagStr);
    }
}

